/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.util;

import com.liferay.depot.internal.instance.lifecycle.DepotRolesPortalInstanceLifecycleListener;
import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;

public class DepotRoleUtil {
    public static final String[] DEPOT_ROLE_NAMES = new String[]{"Asset Library Administrator", "Asset Library Connected Site Member", "Asset Library Content Reviewer", "Asset Library Member", "Asset Library Owner", "CMS Consumer"};
    private static final Map<String, String> _titleKeys = Collections.unmodifiableMap(HashMapBuilder.put((Object)"Asset Library Administrator", (Object)"space-administrator").put((Object)"Asset Library Connected Site Member", (Object)"space-connected-site-member").put((Object)"Asset Library Content Reviewer", (Object)"space-content-reviewer").put((Object)"Asset Library Member", (Object)"space-member").put((Object)"Asset Library Owner", (Object)"space-owner").build());

    public static Map<Locale, String> getDescriptionMap(long companyId, Language language, String name) {
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        for (Locale locale : language.getAvailableLocales()) {
            String description = DepotRoleUtil._getDescription(companyId, locale, name);
            if (description == null) continue;
            descriptionMap.put(locale, description);
        }
        return descriptionMap;
    }

    public static Map<Locale, String> getTitleMap(long companyId, Language language, String name) {
        if (!FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-17564")) {
            return null;
        }
        HashMap<Locale, String> titleMap = new HashMap<Locale, String>();
        for (Locale locale : language.getAvailableLocales()) {
            String title = DepotRoleUtil._getTitle(locale, name);
            if (title == null) continue;
            titleMap.put(locale, title);
        }
        return titleMap;
    }

    private static String _getDescription(long companyId, Locale locale, String name) {
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, DepotRolesPortalInstanceLifecycleListener.class);
        if (Objects.equals("Asset Library Administrator", name)) {
            if (FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-17564")) {
                return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"space-administrators-are-super-users-of-their-space-but-cannot-make-other-users-into-space-administrators");
            }
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"asset-library-administrators-are-super-users-of-their-asset-library-but-cannot-make-other-users-into-asset-library-administrators");
        }
        if (Objects.equals("Asset Library Member", name)) {
            if (FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-17564")) {
                return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"all-users-who-belong-to-a-space-have-this-role-within-that-space");
            }
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"all-users-who-belong-to-an-asset-library-have-this-role-within-that-asset-library");
        }
        if (Objects.equals("Asset Library Owner", name)) {
            if (FeatureFlagManagerUtil.isEnabled((long)companyId, (String)"LPD-17564")) {
                return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"space-owners-are-super-users-of-their-space-and-can-assign-space-roles-to-users");
            }
            return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"asset-library-owners-are-super-users-of-their-asset-library-and-can-assign-asset-library-roles-to-users");
        }
        return null;
    }

    private static String _getTitle(Locale locale, String name) {
        String title = _titleKeys.get(name);
        if (Validator.isNull((String)title)) {
            return name;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((Locale)locale, DepotRolesPortalInstanceLifecycleListener.class);
        return ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)title);
    }
}

