/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.security.permission.resource;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.depot.model.DepotEntry"}, service={ModelResourcePermission.class})
public class DepotEntryModelResourcePermission
implements ModelResourcePermission<DepotEntry> {
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference(target="(resource.name=com.liferay.depot)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, DepotEntry depotEntry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, depotEntry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DepotEntry.class.getName(), depotEntry.getDepotEntryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long depotEntryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, depotEntryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DepotEntry.class.getName(), depotEntryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, DepotEntry depotEntry, String actionId) {
        return this._contains(permissionChecker, depotEntry, actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long depotEntryId, String actionId) throws PortalException {
        return this._contains(permissionChecker, this._depotEntryLocalService.getDepotEntry(depotEntryId), actionId);
    }

    public String getModelName() {
        return DepotEntry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }

    private boolean _contains(PermissionChecker permissionChecker, DepotEntry depotEntry, String actionId) {
        if (permissionChecker.hasOwnerPermission(depotEntry.getCompanyId(), DepotEntry.class.getName(), depotEntry.getDepotEntryId(), depotEntry.getUserId(), actionId) || permissionChecker.isGroupMember(depotEntry.getGroupId()) && actionId.equals("VIEW")) {
            return true;
        }
        return permissionChecker.hasPermission(depotEntry.getGroupId(), DepotEntry.class.getName(), depotEntry.getDepotEntryId(), actionId);
    }
}

