/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.search.spi.searcher;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.search.searcher.SearchRequest;
import com.liferay.portal.search.searcher.SearchRequestBuilder;
import com.liferay.portal.search.searcher.SearchRequestBuilderFactory;
import com.liferay.portal.search.spi.searcher.SearchRequestContributor;
import java.util.Collection;
import java.util.function.Function;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"search.request.contributor.id=com.liferay.depot"}, service={SearchRequestContributor.class})
public class DepotSearchRequestContributor
implements SearchRequestContributor {
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private SearchRequestBuilderFactory _searchRequestBuilderFactory;

    public SearchRequest contribute(SearchRequest searchRequest) {
        SearchRequestBuilder searchRequestBuilder = this._searchRequestBuilderFactory.builder(searchRequest);
        SearchContext searchContext = (SearchContext)searchRequestBuilder.withSearchContextGet(Function.identity());
        long[] groupIds = searchContext.getGroupIds();
        if (ArrayUtil.isEmpty((long[])groupIds)) {
            return searchRequest;
        }
        for (long groupId : groupIds) {
            searchContext.setGroupIds(ArrayUtil.append((long[][])new long[][]{searchContext.getGroupIds(), TransformUtil.transformToLongArray((Collection)this._depotEntryGroupRelLocalService.getSearchableDepotEntryGroupRels(groupId, 0, this._depotEntryGroupRelLocalService.getSearchableDepotEntryGroupRelsCount(groupId)), depotEntryGroupRel -> {
                DepotEntry depotEntry = this._depotEntryLocalService.fetchDepotEntry(depotEntryGroupRel.getDepotEntryId());
                return depotEntry.getGroupId();
            })}));
        }
        return searchRequest;
    }
}

