/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.search.spi.model.index.contributor;

import com.liferay.depot.model.DepotEntry;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Localization;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.depot.model.DepotEntry"}, service={ModelDocumentContributor.class})
public class DepotEntryModelDocumentContributor
implements ModelDocumentContributor<DepotEntry> {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Language _language;
    @Reference
    private Localization _localization;

    public void contribute(Document document, DepotEntry depotEntry) {
        Group group = this._groupLocalService.fetchGroup(depotEntry.getGroupId());
        document.addText("description", group.getDescription());
        document.addDate("modified", depotEntry.getModifiedDate());
        document.addText("name", group.getName());
        for (Locale locale : this._language.getAvailableLocales(depotEntry.getGroupId())) {
            String languageId = LocaleUtil.toLanguageId((Locale)locale);
            document.addText(this._localization.getLocalizedName("description", languageId), group.getDescription(locale));
            document.addText(this._localization.getLocalizedName("name", languageId), group.getName(locale));
        }
    }
}

