/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.instance.lifecycle;

import com.liferay.depot.internal.util.DepotRoleUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class DepotRolesPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    @Reference
    private Language _language;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public void portalInstanceRegistered(Company company) throws PortalException {
        for (String name : DepotRoleUtil.DEPOT_ROLE_NAMES) {
            Role role = this._getOrCreateRole(company.getCompanyId(), name);
            this._resourceLocalService.addResources(company.getCompanyId(), 0L, 0L, Role.class.getName(), role.getRoleId(), false, false, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Role _getOrCreateRole(long companyId, String name) throws PortalException {
        Role role = this._roleLocalService.fetchRole(companyId, name);
        if (role == null) {
            boolean addResource = PermissionThreadLocal.isAddResource();
            try {
                PermissionThreadLocal.setAddResource((boolean)false);
                User user = this._userLocalService.getGuestUser(companyId);
                Role role2 = this._roleLocalService.addRole(null, user.getUserId(), null, 0L, name, DepotRoleUtil.getTitleMap(companyId, this._language, name), DepotRoleUtil.getDescriptionMap(companyId, this._language, name), 5, null, null);
                return role2;
            }
            finally {
                PermissionThreadLocal.setAddResource((boolean)addResource);
            }
        }
        return role;
    }
}

