/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.depot.model.impl;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.DepotEntryLocalServiceUtil;

/**
 * The extended model base implementation for the DepotEntry service. Represents a row in the &quot;DepotEntry&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DepotEntryImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DepotEntryImpl
 * @see DepotEntry
 * @generated
 */
public abstract class DepotEntryBaseImpl
	extends DepotEntryModelImpl implements DepotEntry {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a depot entry model instance should use the <code>DepotEntry</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DepotEntryLocalServiceUtil.addDepotEntry(this);
		}
		else {
			DepotEntryLocalServiceUtil.updateDepotEntry(this);
		}
	}

}