/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.model.listener;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalService;
import com.liferay.depot.service.DepotEntryLocalService;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class GroupModelListener
extends BaseModelListener<Group> {
    @Reference
    private DepotEntryGroupRelLocalService _depotEntryGroupRelLocalService;
    @Reference
    private DepotEntryLocalService _depotEntryLocalService;
    @Reference
    private GroupLocalService _groupLocalService;

    public void onAfterCreate(Group group) throws ModelListenerException {
        if (group != null && group.isDepot() && this._isStaging(ServiceContextThreadLocal.getServiceContext())) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                this._copyLiveDepotEntryGroupRelsToStaging(group);
                return null;
            });
        }
    }

    public void onAfterRemove(Group group) throws ModelListenerException {
        super.onAfterRemove((BaseModel)group);
        if (group != null || group.isDepot()) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                DepotEntry depotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(group.getGroupId());
                if (depotEntry != null) {
                    this._depotEntryLocalService.deleteDepotEntry(depotEntry);
                }
                return null;
            });
        }
    }

    public void onBeforeCreate(Group group) throws ModelListenerException {
        try {
            super.onBeforeCreate((BaseModel)group);
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            if (group.isDepot() && this._isStaging(serviceContext)) {
                DepotEntry depotEntry = this._depotEntryLocalService.addDepotEntry(group, serviceContext);
                group.setClassPK(depotEntry.getDepotEntryId());
            }
        }
        catch (PortalException portalException) {
            throw new ModelListenerException((Throwable)portalException);
        }
    }

    public void onBeforeRemove(Group group) throws ModelListenerException {
        super.onBeforeRemove((BaseModel)group);
        if (!group.isSite()) {
            return;
        }
        this._depotEntryGroupRelLocalService.deleteToGroupDepotEntryGroupRels(group.getGroupId());
    }

    private void _copyLiveDepotEntryGroupRelsToStaging(Group group) throws PortalException {
        Group liveGroup = group.getLiveGroup();
        if (liveGroup == null) {
            return;
        }
        DepotEntry liveDepotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(liveGroup.getGroupId());
        if (liveDepotEntry == null) {
            return;
        }
        List depotEntryGroupRels = this._depotEntryGroupRelLocalService.getDepotEntryGroupRels(liveDepotEntry);
        for (DepotEntryGroupRel depotEntryGroupRel : depotEntryGroupRels) {
            Group groupRel = this._groupLocalService.getGroup(depotEntryGroupRel.getGroupId());
            if (!groupRel.isStagingGroup()) continue;
            DepotEntry depotEntry = this._depotEntryLocalService.fetchGroupDepotEntry(group.getGroupId());
            DepotEntryGroupRel stagedDepotEntryGroupRel = this._depotEntryGroupRelLocalService.addDepotEntryGroupRel(depotEntry.getDepotEntryId(), depotEntryGroupRel.getGroupId());
            stagedDepotEntryGroupRel.setDdmStructuresAvailable(depotEntryGroupRel.isDdmStructuresAvailable());
            stagedDepotEntryGroupRel.setSearchable(depotEntryGroupRel.isSearchable());
            this._depotEntryGroupRelLocalService.updateDepotEntryGroupRel(stagedDepotEntryGroupRel);
        }
    }

    private boolean _isStaging(ServiceContext serviceContext) {
        if (serviceContext == null) {
            return false;
        }
        return ParamUtil.getBoolean((ServiceContext)serviceContext, (String)"staging");
    }
}

