/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.depot.model.impl;

import com.liferay.depot.model.DepotEntryGroupRel;
import com.liferay.depot.service.DepotEntryGroupRelLocalServiceUtil;

/**
 * The extended model base implementation for the DepotEntryGroupRel service. Represents a row in the &quot;DepotEntryGroupRel&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DepotEntryGroupRelImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DepotEntryGroupRelImpl
 * @see DepotEntryGroupRel
 * @generated
 */
public abstract class DepotEntryGroupRelBaseImpl
	extends DepotEntryGroupRelModelImpl implements DepotEntryGroupRel {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a depot entry group rel model instance should use the <code>DepotEntryGroupRel</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DepotEntryGroupRelLocalServiceUtil.addDepotEntryGroupRel(this);
		}
		else {
			DepotEntryGroupRelLocalServiceUtil.updateDepotEntryGroupRel(this);
		}
	}

}