/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutTable;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class WidgetLayoutTypeSettingsUpgradeProcess
extends UpgradeProcess {
    private final LayoutLocalService _layoutLocalService;

    public WidgetLayoutTypeSettingsUpgradeProcess(LayoutLocalService layoutLocalService) {
        this._layoutLocalService = layoutLocalService;
    }

    protected void doUpgrade() throws Exception {
        List layouts = this._layoutLocalService.getLayouts((Collection)this._layoutLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{LayoutTable.INSTANCE.plid}).from((Table)LayoutTable.INSTANCE).where(LayoutTable.INSTANCE.type.eq((Object)"content").and((Expression)LayoutTable.INSTANCE.typeSettings.like("%CUSTOMIZABLE_LAYOUT%").or((Expression)LayoutTable.INSTANCE.typeSettings.like("%column-%").or((Expression)LayoutTable.INSTANCE.typeSettings.like("%layout-template-id%"))).withParentheses()))));
        for (Layout layout : layouts) {
            UnicodeProperties typeSettingsUnicodeProperties = layout.getTypeSettingsProperties();
            if (!this._isWidgetLayoutSettingsCleared(typeSettingsUnicodeProperties)) continue;
            this._layoutLocalService.updateTypeSettings(layout, typeSettingsUnicodeProperties.toString());
        }
    }

    private boolean _isWidgetLayoutSettingsCleared(UnicodeProperties typeSettingsUnicodeProperties) {
        int count = typeSettingsUnicodeProperties.size();
        typeSettingsUnicodeProperties.remove((Object)"CUSTOMIZABLE_LAYOUT");
        typeSettingsUnicodeProperties.remove((Object)"layout-template-id");
        Set entries = typeSettingsUnicodeProperties.entrySet();
        entries.removeIf(entry -> {
            String key = (String)entry.getKey();
            return key.startsWith("column-");
        });
        return count != typeSettingsUnicodeProperties.size();
    }
}

