/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade.executor;

import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration;
import com.liferay.data.cleanup.internal.upgrade.DLPreviewCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.ExpiredJournalArticleUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.OutdatedPublishedCTCollectionUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.PublishedCTSContentDataUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.WidgetLayoutTypeSettingsUpgradeProcess;
import com.liferay.data.cleanup.internal.upgrade.util.ConfigurationUtil;
import com.liferay.journal.service.JournalArticleLocalService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.data.cleanup.DataCleanupPreupgradeProcess;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.upgrade.data.cleanup.AnalyticsMessageDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.CompanyDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.ConfigurationDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DDMStructureDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DLFileEntryDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.DataCleanupPreupgradeProcessSuite;
import com.liferay.portal.upgrade.data.cleanup.GroupDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.NullUnicodeContentDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.QuartzJobDetailsDataCleanupPreupgradeProcess;
import com.liferay.portal.upgrade.data.cleanup.UserDataCleanupPreupgradeProcess;
import com.liferay.portal.util.PropsValues;
import java.util.Map;
import java.util.function.Supplier;
import org.apache.felix.cm.PersistenceManager;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={})
public class DataRemovalExecutor {
    private static final Log _log = LogFactoryUtil.getLog(DataRemovalExecutor.class);
    @Reference
    private ConfigurationAdmin _configurationAdmin;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    @Reference
    private JournalArticleLocalService _journalArticleLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private PersistenceManager _persistenceManager;
    @Reference
    private Portal _portal;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    @Activate
    protected void activate(Map<String, Object> properties) throws Exception {
        DataRemovalConfiguration dataRemovalConfiguration = (DataRemovalConfiguration)ConfigurableUtil.createConfigurable(DataRemovalConfiguration.class, properties);
        ConfigurationUtil.deleteConfiguration(this._configurationAdmin, this._persistenceManager, DataRemovalConfiguration.class.getName());
        this._removeModuleData(dataRemovalConfiguration::removeDLPreviewCTSContentData, "com.liferay.change.tracking.service", () -> new DLPreviewCTSContentDataUpgradeProcess(this._ctCollectionLocalService, this._ctEntryLocalService, this._portal));
        this._removeModuleData(dataRemovalConfiguration::removeOutdatedPublishedCTCollections, "com.liferay.change.tracking.service", () -> new OutdatedPublishedCTCollectionUpgradeProcess(this._ctCollectionLocalService));
        this._removeModuleData(dataRemovalConfiguration::removePublishedCTSContentData, "com.liferay.change.tracking.store.service", () -> new PublishedCTSContentDataUpgradeProcess(this._ctsContentLocalService, this._portal));
        this._removeModuleData(dataRemovalConfiguration::removeExpiredJournalArticles, "com.liferay.journal.service", () -> new ExpiredJournalArticleUpgradeProcess(this._journalArticleLocalService));
        this._removeModuleData(dataRemovalConfiguration::removeWidgetLayoutTypeSettings, "com.liferay.layout.service", () -> new WidgetLayoutTypeSettingsUpgradeProcess(this._layoutLocalService));
        this._executeDataCleanupPreupgradeProcesses(dataRemovalConfiguration);
    }

    private void _executeDataCleanupPreupgradeProcesses(DataRemovalConfiguration dataRemovalConfiguration) throws Exception {
        DataCleanupPreupgradeProcessSuite dataCleanupPreupgradeProcessSuite = new DataCleanupPreupgradeProcessSuite();
        for (DataCleanupPreupgradeProcess dataCleanupPreupgradeProcess : dataCleanupPreupgradeProcessSuite.getDataCleanupPreupgradeProcesses()) {
            Class<?> clazz = dataCleanupPreupgradeProcess.getClass();
            if (ArrayUtil.contains((Object[])PropsValues.UPGRADE_DATABASE_PREUPGRADE_DATA_CLEANUP_BLACKLIST, (Object)clazz.getName())) {
                if (!_log.isInfoEnabled()) continue;
                _log.info((Object)("Skipping blacklisted data cleanup process: " + clazz.getName()));
                continue;
            }
            if (!this._isDataCleanupPreupgradeProcessEnabled(dataCleanupPreupgradeProcess, dataRemovalConfiguration)) continue;
            dataCleanupPreupgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }

    private boolean _isDataCleanupPreupgradeProcessEnabled(DataCleanupPreupgradeProcess dataCleanupPreupgradeProcess, DataRemovalConfiguration dataRemovalConfiguration) {
        Class<?> clazz = dataCleanupPreupgradeProcess.getClass();
        if (clazz.equals(AnalyticsMessageDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeAnalyticsMessageData();
        }
        if (clazz.equals(CompanyDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeCompanyOrphanData();
        }
        if (clazz.equals(ConfigurationDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeConfigurationOrphanData();
        }
        if (clazz.equals(DDMStructureDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeDDMStructureOrphanData();
        }
        if (clazz.equals(DLFileEntryDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeDLFileEntryOrphanData();
        }
        if (clazz.equals(GroupDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeGroupOrphanData();
        }
        if (clazz.equals(NullUnicodeContentDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeNullUnicodeContentData();
        }
        if (clazz.equals(QuartzJobDetailsDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeQuartzJobDetailsData();
        }
        if (clazz.equals(UserDataCleanupPreupgradeProcess.class)) {
            return dataRemovalConfiguration.removeUserOrphanData();
        }
        return false;
    }

    private void _removeModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws Exception {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

