/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.upgrade.BaseUpgradeProcess;
import com.liferay.message.boards.service.MBMessageLocalService;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.ratings.kernel.service.RatingsStatsLocalService;
import com.liferay.subscription.service.SubscriptionLocalService;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class SoftwareCatalogUpgradeProcess
extends BaseUpgradeProcess {
    private final ImageLocalService _imageLocalService;
    private final MBMessageLocalService _mbMessageLocalService;
    private final RatingsStatsLocalService _ratingsStatsLocalService;
    private final SubscriptionLocalService _subscriptionLocalService;

    public SoftwareCatalogUpgradeProcess(ImageLocalService imageLocalService, MBMessageLocalService mbMessageLocalService, RatingsStatsLocalService ratingsStatsLocalService, SubscriptionLocalService subscriptionLocalService) {
        this._imageLocalService = imageLocalService;
        this._mbMessageLocalService = mbMessageLocalService;
        this._ratingsStatsLocalService = ratingsStatsLocalService;
        this._subscriptionLocalService = subscriptionLocalService;
    }

    protected void doUpgrade() throws Exception {
        this._deleteImages();
        this._deleteSocial();
        this.removePortletData(null, new String[]{"98"}, new String[]{"com.liferay.portlet.softwarecatalog"});
        this.removeServiceData(null, new String[]{"com.liferay.softwarecatalog.service"}, new String[]{"com.liferay.portlet.softwarecatalog", "com.liferay.portlet.softwarecatalog.model.SCFrameworkVersion", "com.liferay.portlet.softwarecatalog.model.SCLicense", "com.liferay.portlet.softwarecatalog.model.SCProductEntry", "com.liferay.portlet.softwarecatalog.model.SCProductScreenshot", "com.liferay.portlet.softwarecatalog.model.SCProductVersion"}, new String[]{"SCFrameworkVersion", "SCFrameworkVersi_SCProductVers", "SCLicense", "SCLicenses_SCProductEntries", "SCProductEntry", "SCProductScreenshot", "SCProductVersion"});
    }

    private void _deleteImages() throws Exception {
        if (!this.hasTable("SCProductScreenshot")) {
            return;
        }
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select fullImageId, thumbnailId from SCProductScreenshot");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long fullImageId = resultSet.getLong("fullImageId");
                this._imageLocalService.deleteImage(fullImageId);
                long thumbnailId = resultSet.getLong("thumbnailId");
                this._imageLocalService.deleteImage(thumbnailId);
            }
        }
    }

    private void _deleteSocial() throws Exception {
        if (!this.hasTable("SCProductEntry")) {
            return;
        }
        String className = "com.liferay.portlet.softwarecatalog.model.SCProductEntry";
        try (PreparedStatement preparedStatement = this.connection.prepareStatement("select companyId, productEntryId from SCProductEntry");
             ResultSet resultSet = preparedStatement.executeQuery();){
            while (resultSet.next()) {
                long productEntryId = resultSet.getLong("productEntryId");
                this._mbMessageLocalService.deleteDiscussionMessages(className, productEntryId);
                this._ratingsStatsLocalService.deleteStats(className, productEntryId);
                long companyId = resultSet.getLong("companyId");
                this._subscriptionLocalService.deleteSubscriptions(companyId, className, productEntryId);
            }
        }
    }
}

