/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.data.cleanup.internal.upgrade.LayoutTypeSettingsUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.dao.orm.common.SQLTransformer;
import com.liferay.portal.kernel.service.ImageLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

public class UpgradeShopping
extends UpgradeProcess {
    private static final String[] _TABLE_NAMES = new String[]{"ShoppingCart", "ShoppingCategory", "ShoppingCoupon", "ShoppingItem", "ShoppingItemField", "ShoppingItemPrice", "ShoppingOrder", "ShoppingOrderItem"};
    private final ImageLocalService _imageLocalService;

    public UpgradeShopping(ImageLocalService imageLocalService) {
        this._imageLocalService = imageLocalService;
    }

    protected void doUpgrade() throws Exception {
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingCart'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingCategory'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingCoupon'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingItem'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingItemField'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingItemPrice'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingOrder'");
        this.runSQL("delete from ClassName_ where value = 'com.liferay.shopping.model.ShoppingOrderItem'");
        this._deleteImages("smallImage");
        this._deleteImages("mediumImage");
        this._deleteImages("largeImage");
        LayoutTypeSettingsUtil.removePortletId(this.connection, "com_liferay_shopping_web_portlet_ShoppingPortlet");
        this.runSQL("delete from Portlet where portletId = 'com_liferay_shopping_web_portlet_ShoppingAdminPortlet'");
        this.runSQL("delete from Portlet where portletId = 'com_liferay_shopping_web_portlet_ShoppingPortlet'");
        this.runSQL("delete from PortletPreferences where portletId = 'com_liferay_shopping_web_portlet_ShoppingAdminPortlet'");
        this.runSQL("delete from PortletPreferences where portletId = 'com_liferay_shopping_web_portlet_ShoppingPortlet'");
        this.runSQL("delete from Release_ where servletContextName = 'com.liferay.shopping.service'");
        this.runSQL("delete from Release_ where servletContextName = 'com.liferay.shopping.web'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingCart'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingCategory'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingCoupon'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingItem'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingItemField'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingItemPrice'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingOrder'");
        this.runSQL("delete from ResourcePermission where name = 'com.liferay.shopping.model.ShoppingOrderItem'");
        this.runSQL("delete from ServiceComponent where buildNamespace = 'Shopping'");
        this._dropTables();
    }

    private void _deleteImages(String type) throws Exception {
        try (PreparedStatement ps = this.connection.prepareStatement(SQLTransformer.transform((String)StringBundler.concat((String[])new String[]{"select ", type, "Id from ShoppingItem where ", type, " = [$TRUE$]"})));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                this._imageLocalService.deleteImage(rs.getLong(1));
            }
        }
    }

    private void _dropTables() throws Exception {
        for (String tableName : _TABLE_NAMES) {
            if (!this.hasTable(tableName)) continue;
            this.runSQL("drop table " + tableName);
        }
    }
}

