/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.store.service.CTSContentLocalService;
import com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration;
import com.liferay.data.cleanup.internal.upgrade.UpgradeDLPreviewCTSContentData;
import com.liferay.data.cleanup.internal.upgrade.UpgradePublishedCTSContentData;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.cache.CacheRegistryUtil;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;
import java.util.Map;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.data.cleanup.internal.configuration.DataRemovalConfiguration"}, immediate=true, service={UpgradeStepRegistrator.class})
public class DataRemoval
implements UpgradeStepRegistrator {
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTSContentLocalService _ctsContentLocalService;
    private DataRemovalConfiguration _dataRemovalConfiguration;
    @Reference
    private Portal _portal;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    public void register(UpgradeStepRegistrator.Registry registry) {
        try {
            this._removeModuleData(this._dataRemovalConfiguration::removeDLPreviewCTSContentData, "com.liferay.change.tracking.service", () -> new UpgradeDLPreviewCTSContentData(this._ctCollectionLocalService, this._ctEntryLocalService, this._portal));
            this._removeModuleData(this._dataRemovalConfiguration::removePublishedCTSContentData, "com.liferay.change.tracking.store.service", () -> new UpgradePublishedCTSContentData(this._ctsContentLocalService, this._portal));
        }
        catch (UpgradeException upgradeException) {
            ReflectionUtil.throwException((Throwable)upgradeException);
        }
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._dataRemovalConfiguration = (DataRemovalConfiguration)ConfigurableUtil.createConfigurable(DataRemovalConfiguration.class, properties);
    }

    private void _removeModuleData(Supplier<Boolean> booleanSupplier, String servletContextName, Supplier<UpgradeProcess> upgradeProcessSupplier) throws UpgradeException {
        Release release;
        if (booleanSupplier.get().booleanValue() && (release = this._releaseLocalService.fetchRelease(servletContextName)) != null) {
            UpgradeProcess upgradeProcess = upgradeProcessSupplier.get();
            upgradeProcess.upgrade();
            CacheRegistryUtil.clear();
        }
    }
}

