/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.data.cleanup.internal.upgrade;

import com.liferay.petra.string.CharPool;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringPool;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * @author Preston Crary
 */
public class LayoutTypeSettingsUtil {

	public static void removePortletId(Connection connection, String portletId)
		throws Exception {

		try (PreparedStatement selectPS = connection.prepareStatement(
				StringBundler.concat(
					"select plid, typeSettings from Layout where typeSettings ",
					"like '%", portletId, "%'"));
			PreparedStatement updatePS =
				AutoBatchPreparedStatementUtil.autoBatch(
					connection.prepareStatement(
						"update Layout set typeSettings = ? where plid = ?"));
			ResultSet rs = selectPS.executeQuery()) {

			while (rs.next()) {
				long plid = rs.getLong(1);
				String typeSettings = rs.getString(2);

				UnicodeProperties unicodeProperties = new UnicodeProperties(
					true);

				unicodeProperties.fastLoad(typeSettings);

				Set<Map.Entry<String, String>> entrySet =
					unicodeProperties.entrySet();

				Iterator<Map.Entry<String, String>> iterator =
					entrySet.iterator();

				while (iterator.hasNext()) {
					Map.Entry<String, String> entry = iterator.next();

					String value = entry.getValue();

					if (!value.contains(portletId)) {
						continue;
					}

					List<String> parts = StringUtil.split(
						value, CharPool.COMMA);

					if (parts.size() <= 1) {
						iterator.remove();

						continue;
					}

					StringBundler sb = new StringBundler(
						(2 * parts.size()) - 2);

					for (String part : parts) {
						if (!part.startsWith(portletId)) {
							sb.append(part);
							sb.append(StringPool.COMMA);
						}
					}

					if (sb.index() == 0) {
						iterator.remove();

						continue;
					}

					sb.setIndex(sb.index() - 1);

					entry.setValue(sb.toString());
				}

				updatePS.setString(1, unicodeProperties.toString());

				updatePS.setLong(2, plid);

				updatePS.addBatch();
			}

			updatePS.executeBatch();
		}
	}

}