/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.service.persistence.impl;

import com.liferay.contacts.exception.NoSuchEntryException;
import com.liferay.contacts.model.Entry;
import com.liferay.contacts.model.EntryTable;
import com.liferay.contacts.model.impl.EntryImpl;
import com.liferay.contacts.model.impl.EntryModelImpl;
import com.liferay.contacts.service.persistence.EntryPersistence;
import com.liferay.contacts.service.persistence.EntryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntryPersistence.class})
public class EntryPersistenceImpl
extends BasePersistenceImpl<Entry>
implements EntryPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = EntryImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByUserId;
    private FinderPath _finderPathWithoutPaginationFindByUserId;
    private FinderPath _finderPathCountByUserId;
    private static final String _FINDER_COLUMN_USERID_USERID_2 = "entry.userId = ?";
    private FinderPath _finderPathFetchByU_EA;
    private static final String _FINDER_COLUMN_U_EA_USERID_2 = "entry.userId = ? AND ";
    private static final String _FINDER_COLUMN_U_EA_EMAILADDRESS_2 = "entry.emailAddress = ?";
    private static final String _FINDER_COLUMN_U_EA_EMAILADDRESS_3 = "(entry.emailAddress IS NULL OR entry.emailAddress = '')";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_ENTRY = "SELECT entry FROM Entry entry";
    private static final String _SQL_SELECT_ENTRY_WHERE = "SELECT entry FROM Entry entry WHERE ";
    private static final String _SQL_COUNT_ENTRY = "SELECT COUNT(entry) FROM Entry entry";
    private static final String _SQL_COUNT_ENTRY_WHERE = "SELECT COUNT(entry) FROM Entry entry WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "entry.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No Entry exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No Entry exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(EntryPersistenceImpl.class);

    public List<Entry> findByUserId(long userId) {
        return this.findByUserId(userId, -1, -1, null);
    }

    public List<Entry> findByUserId(long userId, int start, int end) {
        return this.findByUserId(userId, start, end, null);
    }

    public List<Entry> findByUserId(long userId, int start, int end, OrderByComparator<Entry> orderByComparator) {
        return this.findByUserId(userId, start, end, orderByComparator, true);
    }

    public List<Entry> findByUserId(long userId, int start, int end, OrderByComparator<Entry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByUserId;
                finderArgs = new Object[]{userId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByUserId;
            finderArgs = new Object[]{userId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (Entry entry : list) {
                if (userId == entry.getUserId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_ENTRY_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY entry.fullName ASC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public Entry findByUserId_First(long userId, OrderByComparator<Entry> orderByComparator) throws NoSuchEntryException {
        Entry entry = this.fetchByUserId_First(userId, orderByComparator);
        if (entry != null) {
            return entry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public Entry fetchByUserId_First(long userId, OrderByComparator<Entry> orderByComparator) {
        List<Entry> list = this.findByUserId(userId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Entry findByUserId_Last(long userId, OrderByComparator<Entry> orderByComparator) throws NoSuchEntryException {
        Entry entry = this.fetchByUserId_Last(userId, orderByComparator);
        if (entry != null) {
            return entry;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("userId=");
        sb.append(userId);
        sb.append("}");
        throw new NoSuchEntryException(sb.toString());
    }

    public Entry fetchByUserId_Last(long userId, OrderByComparator<Entry> orderByComparator) {
        int count = this.countByUserId(userId);
        if (count == 0) {
            return null;
        }
        List<Entry> list = this.findByUserId(userId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public Entry[] findByUserId_PrevAndNext(long entryId, long userId, OrderByComparator<Entry> orderByComparator) throws NoSuchEntryException {
        Entry entry = this.findByPrimaryKey(entryId);
        Session session = null;
        try {
            session = this.openSession();
            Entry[] array = new EntryImpl[]{this.getByUserId_PrevAndNext(session, entry, userId, orderByComparator, true), entry, this.getByUserId_PrevAndNext(session, entry, userId, orderByComparator, false)};
            Entry[] entryArray = array;
            return entryArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Entry getByUserId_PrevAndNext(Session session, Entry entry, long userId, OrderByComparator<Entry> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_ENTRY_WHERE);
        sb.append(_FINDER_COLUMN_USERID_USERID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY entry.fullName ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(userId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)entry)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (Entry)list.get(1);
        }
        return null;
    }

    public void removeByUserId(long userId) {
        for (Entry entry : this.findByUserId(userId, -1, -1, null)) {
            this.remove((BaseModel)entry);
        }
    }

    public int countByUserId(long userId) {
        FinderPath finderPath = this._finderPathCountByUserId;
        Object[] finderArgs = new Object[]{userId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_ENTRY_WHERE);
            sb.append(_FINDER_COLUMN_USERID_USERID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Entry findByU_EA(long userId, String emailAddress) throws NoSuchEntryException {
        Entry entry = this.fetchByU_EA(userId, emailAddress);
        if (entry == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("userId=");
            sb.append(userId);
            sb.append(", emailAddress=");
            sb.append(emailAddress);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchEntryException(sb.toString());
        }
        return entry;
    }

    public Entry fetchByU_EA(long userId, String emailAddress) {
        return this.fetchByU_EA(userId, emailAddress, true);
    }

    public Entry fetchByU_EA(long userId, String emailAddress, boolean useFinderCache) {
        Entry entry;
        emailAddress = Objects.toString(emailAddress, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{userId, emailAddress};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByU_EA, finderArgs, (BasePersistence)this);
        }
        if (result instanceof Entry && (userId != (entry = (Entry)result).getUserId() || !Objects.equals(emailAddress, entry.getEmailAddress()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_SELECT_ENTRY_WHERE);
            sb.append(_FINDER_COLUMN_U_EA_USERID_2);
            boolean bindEmailAddress = false;
            if (emailAddress.isEmpty()) {
                sb.append(_FINDER_COLUMN_U_EA_EMAILADDRESS_3);
            } else {
                bindEmailAddress = true;
                sb.append(_FINDER_COLUMN_U_EA_EMAILADDRESS_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(userId);
                if (bindEmailAddress) {
                    queryPos.add(emailAddress);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByU_EA, finderArgs, (Object)list);
                    }
                } else {
                    Entry entry2 = (Entry)list.get(0);
                    result = entry2;
                    this.cacheResult(entry2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (Entry)result;
    }

    public Entry removeByU_EA(long userId, String emailAddress) throws NoSuchEntryException {
        Entry entry = this.findByU_EA(userId, emailAddress);
        return (Entry)this.remove((BaseModel)entry);
    }

    public int countByU_EA(long userId, String emailAddress) {
        Entry entry = this.fetchByU_EA(userId, emailAddress);
        if (entry == null) {
            return 0;
        }
        return 1;
    }

    public EntryPersistenceImpl() {
        this.setModelClass(Entry.class);
        this.setModelImplClass(EntryImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)EntryTable.INSTANCE);
    }

    public void cacheResult(Entry entry) {
        this.entityCache.putResult(EntryImpl.class, (Serializable)Long.valueOf(entry.getPrimaryKey()), (Serializable)entry);
        this.finderCache.putResult(this._finderPathFetchByU_EA, new Object[]{entry.getUserId(), entry.getEmailAddress()}, (Object)entry);
    }

    public void cacheResult(List<Entry> entries) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && entries.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (Entry entry : entries) {
            if (this.entityCache.getResult(EntryImpl.class, (Serializable)Long.valueOf(entry.getPrimaryKey())) != null) continue;
            this.cacheResult(entry);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(EntryImpl.class);
        this.finderCache.clearCache(EntryImpl.class);
    }

    public void clearCache(Entry entry) {
        this.entityCache.removeResult(EntryImpl.class, (BaseModel)entry);
    }

    public void clearCache(List<Entry> entries) {
        for (Entry entry : entries) {
            this.entityCache.removeResult(EntryImpl.class, (BaseModel)entry);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(EntryImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(EntryImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(EntryModelImpl entryModelImpl) {
        Object[] args = new Object[]{entryModelImpl.getUserId(), entryModelImpl.getEmailAddress()};
        this.finderCache.putResult(this._finderPathFetchByU_EA, args, (Object)entryModelImpl);
    }

    public Entry create(long entryId) {
        EntryImpl entry = new EntryImpl();
        entry.setNew(true);
        entry.setPrimaryKey(entryId);
        entry.setCompanyId(CompanyThreadLocal.getCompanyId());
        return entry;
    }

    public Entry remove(long entryId) throws NoSuchEntryException {
        return this.remove(Long.valueOf(entryId));
    }

    public Entry remove(Serializable primaryKey) throws NoSuchEntryException {
        Session session = null;
        try {
            session = this.openSession();
            Entry entry = (Entry)session.get(EntryImpl.class, primaryKey);
            if (entry == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            Entry entry2 = (Entry)this.remove((BaseModel)entry);
            return entry2;
        }
        catch (NoSuchEntryException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected Entry removeImpl(Entry entry) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)entry)) {
                entry = (Entry)session.get(EntryImpl.class, entry.getPrimaryKeyObj());
            }
            if (entry != null) {
                session.delete((Object)entry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (entry != null) {
            this.clearCache(entry);
        }
        return entry;
    }

    public Entry updateImpl(Entry entry) {
        boolean isNew = entry.isNew();
        if (!(entry instanceof EntryModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)entry.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)entry);
                throw new IllegalArgumentException("Implement ModelWrapper in entry proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom Entry implementation " + String.valueOf(entry.getClass()));
        }
        EntryModelImpl entryModelImpl = (EntryModelImpl)entry;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && entry.getCreateDate() == null) {
            if (serviceContext == null) {
                entry.setCreateDate(date);
            } else {
                entry.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!entryModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                entry.setModifiedDate(date);
            } else {
                entry.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)entry);
            } else {
                entry = (Entry)session.merge((Object)entry);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(EntryImpl.class, (BaseModel)entryModelImpl, false, true);
        this.cacheUniqueFindersCache(entryModelImpl);
        if (isNew) {
            entry.setNew(false);
        }
        entry.resetOriginalValues();
        return entry;
    }

    public Entry findByPrimaryKey(Serializable primaryKey) throws NoSuchEntryException {
        Entry entry = (Entry)this.fetchByPrimaryKey(primaryKey);
        if (entry == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchEntryException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return entry;
    }

    public Entry findByPrimaryKey(long entryId) throws NoSuchEntryException {
        return this.findByPrimaryKey(Long.valueOf(entryId));
    }

    public Entry fetchByPrimaryKey(long entryId) {
        return (Entry)this.fetchByPrimaryKey(Long.valueOf(entryId));
    }

    public List<Entry> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<Entry> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<Entry> findAll(int start, int end, OrderByComparator<Entry> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<Entry> findAll(int start, int end, OrderByComparator<Entry> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_ENTRY);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_ENTRY;
                sql = sql.concat(" ORDER BY entry.fullName ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (Entry entry : this.findAll()) {
            this.remove((BaseModel)entry);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_ENTRY);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "entryId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_ENTRY;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return EntryModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByUserId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"userId"}, true);
        this._finderPathWithoutPaginationFindByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, true);
        this._finderPathCountByUserId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByUserId", new String[]{Long.class.getName()}, new String[]{"userId"}, false);
        this._finderPathFetchByU_EA = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByU_EA", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"userId", "emailAddress"}, true);
        EntryUtil.setPersistence((EntryPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        EntryUtil.setPersistence(null);
        this.entityCache.removeCache(EntryImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.contacts.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.contacts.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.contacts.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

