/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.service.persistence.impl;

import com.liferay.contacts.model.Entry;
import com.liferay.contacts.model.impl.EntryImpl;
import com.liferay.contacts.service.persistence.EntryFinder;
import com.liferay.contacts.service.persistence.EntryUtil;
import com.liferay.contacts.service.persistence.impl.EntryFinderBaseImpl;
import com.liferay.portal.dao.orm.custom.sql.CustomSQL;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.SQLQuery;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.Type;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.util.comparator.UserLastNameComparator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={EntryFinder.class})
public class EntryFinderImpl
extends EntryFinderBaseImpl
implements EntryFinder {
    public static final String COUNT_BY_U_FN_EA = EntryFinder.class.getName() + ".countByU_FN_EA";
    public static final String FIND_BY_U_FN_EA = EntryFinder.class.getName() + ".findByU_FN_EA";
    @Reference
    private CustomSQL _customSQL;
    @Reference
    private UserLocalService _userLocalService;

    public int countByKeywords(long companyId, long userId, String keywords) {
        if (Validator.isNotNull((String)keywords)) {
            int count = this._userLocalService.searchCount(companyId, keywords, keywords, keywords, keywords, keywords, 0, null, false);
            String[] fullNames = this._customSQL.keywords(keywords);
            String[] emailAddresses = this._customSQL.keywords(keywords);
            return count += this.countByU_FN_EA(userId, fullNames, emailAddresses);
        }
        int count = this._userLocalService.getUsersCount(companyId, 0);
        return count += EntryUtil.countByUserId((long)userId);
    }

    public int countByKeywords(long userId, String keywords) {
        if (Validator.isNotNull((String)keywords)) {
            String[] fullNames = this._customSQL.keywords(keywords);
            String[] emailAddresses = this._customSQL.keywords(keywords);
            return this.countByU_FN_EA(userId, fullNames, emailAddresses);
        }
        return EntryUtil.countByUserId((long)userId);
    }

    public List<BaseModel<?>> findByKeywords(long companyId, long userId, String keywords, int start, int end) {
        ArrayList baseModels = new ArrayList();
        if (Validator.isNotNull((String)keywords)) {
            baseModels.addAll(this._userLocalService.search(companyId, keywords, keywords, keywords, keywords, keywords, 0, null, false, start, end, (OrderByComparator)UserLastNameComparator.getInstance((boolean)true)));
            if (baseModels.size() < end - start) {
                int count = this._userLocalService.searchCount(companyId, keywords, keywords, keywords, keywords, keywords, 0, null, false);
                String[] fullNames = this._customSQL.keywords(keywords);
                String[] emailAddresses = this._customSQL.keywords(keywords);
                baseModels.addAll(this.findByU_FN_EA(userId, fullNames, emailAddresses, start -= count, end -= count));
            }
        } else {
            baseModels.addAll(this._userLocalService.getUsers(companyId, 0, start, end, (OrderByComparator)UserLastNameComparator.getInstance((boolean)true)));
            if (baseModels.size() < end - start) {
                int count = this._userLocalService.getUsersCount(companyId, 0);
                baseModels.addAll(EntryUtil.findByUserId((long)userId, (int)(start -= count), (int)(end -= count)));
            }
        }
        return baseModels;
    }

    public List<Entry> findByKeywords(long userId, String keywords, int start, int end) {
        if (Validator.isNotNull((String)keywords)) {
            String[] fullNames = this._customSQL.keywords(keywords);
            String[] emailAddresses = this._customSQL.keywords(keywords);
            return this.findByU_FN_EA(userId, fullNames, emailAddresses, start, end);
        }
        return EntryUtil.findByUserId((long)userId, (int)start, (int)end);
    }

    protected int countByU_FN_EA(long userId, String[] fullNames, String[] emailAddresses) {
        fullNames = this._customSQL.keywords(fullNames, true);
        emailAddresses = this._customSQL.keywords(emailAddresses, true);
        Session session = null;
        try {
            Long count;
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), COUNT_BY_U_FN_EA);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(fullName)", "LIKE", false, fullNames);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(emailAddress)", "LIKE", true, emailAddresses);
            sql = this._customSQL.replaceAndOperator(sql, false);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addScalar("COUNT_VALUE", Type.LONG);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            queryPos.add(fullNames, 2);
            queryPos.add(emailAddresses, 2);
            Iterator iterator = sqlQuery.iterate();
            if (iterator.hasNext() && (count = (Long)iterator.next()) != null) {
                int n = count.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected List<Entry> findByU_FN_EA(long userId, String[] fullNames, String[] emailAddresses, int start, int end) {
        fullNames = this._customSQL.keywords(fullNames, true);
        emailAddresses = this._customSQL.keywords(emailAddresses, true);
        Session session = null;
        try {
            session = this.openSession();
            String sql = this._customSQL.get(((Object)((Object)this)).getClass(), FIND_BY_U_FN_EA);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(fullName)", "LIKE", false, fullNames);
            sql = this._customSQL.replaceKeywords(sql, "LOWER(emailAddress)", "LIKE", true, emailAddresses);
            sql = this._customSQL.replaceAndOperator(sql, false);
            SQLQuery sqlQuery = session.createSynchronizedSQLQuery(sql);
            sqlQuery.addEntity("Contacts_Entry", EntryImpl.class);
            QueryPos queryPos = QueryPos.getInstance((Query)sqlQuery);
            queryPos.add(userId);
            queryPos.add(fullNames, 2);
            queryPos.add(emailAddresses, 2);
            List list = QueryUtil.list((Query)sqlQuery, (Dialect)this.getDialect(), (int)start, (int)end);
            return list;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

