/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.service.base;

import com.liferay.contacts.model.Entry;
import com.liferay.contacts.service.EntryLocalService;
import com.liferay.contacts.service.persistence.EntryFinder;
import com.liferay.contacts.service.persistence.EntryPersistence;
import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.Serializable;
import java.sql.Connection;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

public abstract class EntryLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
EntryLocalService,
IdentifiableOSGiService {
    protected EntryLocalService entryLocalService;
    @Reference
    protected EntryPersistence entryPersistence;
    @Reference
    protected EntryFinder entryFinder;
    @Reference
    protected CounterLocalService counterLocalService;
    private static final Log _log = LogFactoryUtil.getLog(EntryLocalServiceBaseImpl.class);

    @Indexable(type=IndexableType.REINDEX)
    public Entry addEntry(Entry entry) {
        entry.setNew(true);
        return (Entry)this.entryPersistence.update((BaseModel)entry);
    }

    @Transactional(enabled=false)
    public Entry createEntry(long entryId) {
        return this.entryPersistence.create(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Entry deleteEntry(long entryId) throws PortalException {
        return this.entryPersistence.remove(entryId);
    }

    @Indexable(type=IndexableType.DELETE)
    public Entry deleteEntry(Entry entry) throws PortalException {
        return (Entry)this.entryPersistence.remove((BaseModel)entry);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.entryPersistence.dslQuery(dslQuery);
    }

    public int dslQueryCount(DSLQuery dslQuery) {
        Long count = (Long)this.dslQuery(dslQuery);
        return count.intValue();
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(Entry.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.entryPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.entryPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.entryPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.entryPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.entryPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public Entry fetchEntry(long entryId) {
        return this.entryPersistence.fetchByPrimaryKey(entryId);
    }

    public Entry getEntry(long entryId) throws PortalException {
        return this.entryPersistence.findByPrimaryKey(entryId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.entryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Entry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.entryLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(Entry.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.entryLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(Entry.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("entryId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.entryPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        if (_log.isWarnEnabled()) {
            _log.warn((Object)"Implement EntryLocalServiceImpl#deleteEntry(Entry) to avoid orphaned data");
        }
        return this.entryLocalService.deleteEntry((Entry)persistedModel);
    }

    public BasePersistence<Entry> getBasePersistence() {
        return this.entryPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.entryPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<Entry> getEntries(int start, int end) {
        return this.entryPersistence.findAll(start, end);
    }

    public int getEntriesCount() {
        return this.entryPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public Entry updateEntry(Entry entry) {
        return (Entry)this.entryPersistence.update((BaseModel)entry);
    }

    @Deactivate
    protected void deactivate() {
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{EntryLocalService.class, IdentifiableOSGiService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.entryLocalService = (EntryLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return EntryLocalService.class.getName();
    }

    protected Class<?> getModelClass() {
        return Entry.class;
    }

    protected String getModelClassName() {
        return Entry.class.getName();
    }

    protected void runSQL(String sql) {
        DataSource dataSource = this.entryPersistence.getDataSource();
        DB db = DBManagerUtil.getDB();
        Connection currentConnection = CurrentConnectionUtil.getConnection((DataSource)dataSource);
        try {
            if (currentConnection != null) {
                db.runSQL(currentConnection, new String[]{sql});
                return;
            }
            try (Connection connection = dataSource.getConnection();){
                db.runSQL(connection, new String[]{sql});
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

