/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.internal.security.permission.resource;

import com.liferay.contacts.model.Entry;
import com.liferay.contacts.service.EntryLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.contacts.model.Entry"}, service={ModelResourcePermission.class})
public class EntryModelResourcePermission
implements ModelResourcePermission<Entry> {
    @Reference
    protected EntryLocalService entryLocalService;

    public void check(PermissionChecker permissionChecker, Entry entry, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, entry, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Entry.class.getName(), entry.getEntryId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, entryId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, Entry.class.getName(), entryId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, Entry entry, String actionId) throws PortalException {
        return this.contains(permissionChecker, entry.getEntryId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long entryId, String actionId) throws PortalException {
        Entry entry = this.entryLocalService.fetchEntry(entryId);
        if (entry != null && permissionChecker.hasOwnerPermission(permissionChecker.getCompanyId(), Entry.class.getName(), entryId, entry.getUserId(), actionId)) {
            return true;
        }
        return permissionChecker.hasPermission(entry.getGroupId(), Entry.class.getName(), entryId, actionId);
    }

    public String getModelName() {
        return Entry.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }
}

