/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.contacts.internal.search.spi.model.index.contributor;

import com.liferay.portal.kernel.model.Contact;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"indexer.class.name=com.liferay.portal.kernel.model.Contact"}, service={ModelDocumentContributor.class})
public class ContactModelDocumentContributor
implements ModelDocumentContributor<Contact> {
    @Reference
    protected UserLocalService userLocalService;

    public void contribute(Document document, Contact contact) {
        User user;
        if (contact.isUser() && ((user = this.userLocalService.fetchUserByContactId(contact.getContactId())) == null || user.isGuestUser() || user.getStatus() != 0)) {
            return;
        }
        document.addKeyword("companyId", contact.getCompanyId());
        document.addDate("modified", contact.getModifiedDate());
        document.addKeyword("userId", contact.getUserId());
        document.addKeyword("userName", contact.getFullName());
        document.addText("emailAddress", contact.getEmailAddress());
        document.addText("firstName", contact.getFirstName());
        document.addText("fullName", contact.getFullName());
        document.addText("jobTitle", contact.getJobTitle());
        document.addText("lastName", contact.getLastName());
        document.addText("middleName", contact.getMiddleName());
    }
}

