/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.punchout.internal.model.listener;

import com.liferay.commerce.model.CommerceOrder;
import com.liferay.commerce.punchout.service.PunchOutAccountRoleHelper;
import com.liferay.commerce.service.CommerceOrderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import java.util.Collections;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class CommerceOrderModelListener
extends BaseModelListener<CommerceOrder> {
    private static final Log _log = LogFactoryUtil.getLog(CommerceOrderModelListener.class);
    @Reference
    private CommerceOrderLocalService _commerceOrderLocalService;
    @Reference
    private PunchOutAccountRoleHelper _punchOutAccountRoleHelper;

    public void onAfterUpdate(CommerceOrder originalCommerceOrder, CommerceOrder commerceOrder) {
        try {
            if (commerceOrder.getStatus() != 2 || !this._punchOutAccountRoleHelper.hasPunchOutRole(commerceOrder.getUserId(), commerceOrder.getCommerceAccountId())) {
                return;
            }
            this._commerceOrderLocalService.updateStatus(commerceOrder.getUserId(), commerceOrder.getCommerceOrderId(), 0, Collections.emptyMap());
        }
        catch (PortalException portalException) {
            _log.error((Object)("Failed to update workflow status to Approved on punch out order" + commerceOrder.getCommerceOrderId()), (Throwable)portalException);
        }
    }
}

