/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.commerce.punchout.helper;

import com.liferay.account.model.AccountEntry;
import com.liferay.account.model.AccountEntryUserRel;
import com.liferay.account.service.AccountEntryLocalService;
import com.liferay.account.service.AccountEntryUserRelLocalService;
import com.liferay.commerce.punchout.service.PunchOutAccountRoleHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.model.UserGroupRole;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PunchOutAccountRoleHelper.class})
public class PunchOutAccountRoleHelperImpl
implements PunchOutAccountRoleHelper {
    @Reference
    private AccountEntryLocalService _accountEntryLocalService;
    @Reference
    private AccountEntryUserRelLocalService _accountEntryUserRelLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public boolean hasPunchOutRole(long userId, long accountEntryId) throws PortalException {
        List accountEntryUserRels = this._accountEntryUserRelLocalService.getAccountEntryUserRelsByAccountEntryId(accountEntryId);
        if (accountEntryUserRels.isEmpty()) {
            return false;
        }
        User user = this._userLocalService.fetchUser(userId);
        if (user == null) {
            return false;
        }
        Role punchOutRole = this._roleLocalService.fetchRole(user.getCompanyId(), "Punch Out");
        if (punchOutRole == null) {
            return false;
        }
        for (AccountEntryUserRel accountEntryUserRel : accountEntryUserRels) {
            AccountEntry accountEntry = this._accountEntryLocalService.getAccountEntry(accountEntryId);
            List userGroupRoles = this._userGroupRoleLocalService.getUserGroupRoles(accountEntryUserRel.getAccountUserId(), accountEntry.getAccountEntryGroupId());
            for (UserGroupRole userGroupRole : userGroupRoles) {
                Role role = userGroupRole.getRole();
                if (userGroupRole.getUserId() != userId || role.getRoleId() != punchOutRole.getRoleId()) continue;
                return true;
            }
        }
        return false;
    }
}

