/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.comment.sanitizer.internal;

import com.liferay.portal.kernel.util.StringUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommentAllowedContent {
    private static final Pattern _pattern = Pattern.compile("\\s+");
    private final Map<String, String[]> _attributeNamesMap = new HashMap<String, String[]>();

    public CommentAllowedContent(String allowedContent) {
        String[] allowedContentParts;
        Matcher matcher = _pattern.matcher(allowedContent);
        allowedContent = matcher.replaceAll("");
        String[] stringArray = allowedContentParts = StringUtil.split((String)allowedContent, (String)";");
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String allowedContentPart;
            String elementName = allowedContentPart = stringArray[i];
            String[] attributeNames = new String[]{};
            int x = allowedContentPart.indexOf("[");
            int y = allowedContentPart.indexOf("]");
            if (x != -1 && y != -1) {
                elementName = allowedContentPart.substring(0, x);
                attributeNames = StringUtil.split((String)allowedContentPart.substring(x + 1, y));
            }
            this._attributeNamesMap.put(elementName, attributeNames);
        }
    }

    public Map<String, String[]> getAttributeNames() {
        return this._attributeNamesMap;
    }
}

