/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.service.impl;

import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.service.base.ClientExtensionEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=remoteapp", "json.web.service.context.path=ClientExtensionEntry"}, service={AopService.class})
public class ClientExtensionEntryServiceImpl
extends ClientExtensionEntryServiceBaseImpl {
    @Reference(target="(model.class.name=com.liferay.client.extension.model.ClientExtensionEntry)")
    private ModelResourcePermission<ClientExtensionEntry> _clientExtensionEntryModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.client.extension)")
    private PortletResourcePermission _portletResourcePermission;

    public ClientExtensionEntry addClientExtensionEntry(String externalReferenceCode, String description, Map<Locale, String> nameMap, String properties, String sourceCodeURL, String type, String typeSettings) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), null, "ADD_ENTRY");
        return this.clientExtensionEntryLocalService.addClientExtensionEntry(externalReferenceCode, this.getUserId(), description, nameMap, properties, sourceCodeURL, type, typeSettings);
    }

    public ClientExtensionEntry deleteClientExtensionEntry(long clientExtensionEntryId) throws PortalException {
        this._clientExtensionEntryModelResourcePermission.check(this.getPermissionChecker(), clientExtensionEntryId, "DELETE");
        return this.clientExtensionEntryLocalService.deleteClientExtensionEntry(clientExtensionEntryId);
    }

    public ClientExtensionEntry deleteClientExtensionEntryByExternalReferenceCode(long companyId, String externalReferenceCode) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByERC_C(externalReferenceCode, companyId);
        return this.deleteClientExtensionEntry(clientExtensionEntry.getClientExtensionEntryId());
    }

    public ClientExtensionEntry fetchClientExtensionEntryByExternalReferenceCode(String externalReferenceCode, long companyId) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.fetchByERC_C(externalReferenceCode, companyId);
        if (clientExtensionEntry != null) {
            this._clientExtensionEntryModelResourcePermission.check(this.getPermissionChecker(), clientExtensionEntry.getClientExtensionEntryId(), "VIEW");
        }
        return clientExtensionEntry;
    }

    public ClientExtensionEntry getClientExtensionEntry(long clientExtensionEntryId) throws PortalException {
        this._clientExtensionEntryModelResourcePermission.check(this.getPermissionChecker(), clientExtensionEntryId, "VIEW");
        return this.clientExtensionEntryLocalService.getClientExtensionEntry(clientExtensionEntryId);
    }

    public ClientExtensionEntry updateClientExtensionEntry(long clientExtensionEntryId, String description, Map<Locale, String> nameMap, String properties, String sourceCodeURL, String typeSettings) throws PortalException {
        this._clientExtensionEntryModelResourcePermission.check(this.getPermissionChecker(), clientExtensionEntryId, "UPDATE");
        return this.clientExtensionEntryLocalService.updateClientExtensionEntry(this.getUserId(), clientExtensionEntryId, description, nameMap, properties, sourceCodeURL, typeSettings);
    }
}

