/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.internal.instance.lifecycle;

import com.liferay.client.extension.type.configuration.CETConfiguration;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.instance.lifecycle.BasePortalInstanceLifecycleListener;
import com.liferay.portal.instance.lifecycle.PortalInstanceLifecycleListener;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import java.util.Collection;
import java.util.Dictionary;
import java.util.List;
import java.util.Objects;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={PortalInstanceLifecycleListener.class})
public class ClientExtensionAllCompaniesPortalInstanceLifecycleListener
extends BasePortalInstanceLifecycleListener {
    private static final Log _log = LogFactoryUtil.getLog(ClientExtensionAllCompaniesPortalInstanceLifecycleListener.class);
    @Reference
    private CETManager _cetManager;
    @Reference
    private ConfigurationAdmin _configurationAdmin;

    public void portalInstanceRegistered(Company company) throws Exception {
        List externalReferenceCodes = StringUtil.split((String)PropsUtil.get((String)"client.extension.all.companies.external.reference.codes"));
        if (ListUtil.isEmpty((List)externalReferenceCodes)) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Skipping because no external reference codes were specified");
            }
            return;
        }
        if (Objects.equals(company.getDefaultWebId(), company.getWebId())) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Skipping default company " + company.getWebId()));
            }
            return;
        }
        if (_log.isDebugEnabled()) {
            _log.debug((Object)StringBundler.concat((String[])new String[]{"Add client extensions ", StringUtil.merge((Collection)externalReferenceCodes, (String)", "), " for the default company ", company.getDefaultWebId(), " to company ", company.getWebId()}));
        }
        for (String externalReferenceCode : externalReferenceCodes) {
            Configuration[] configurations = this._configurationAdmin.listConfigurations(StringBundler.concat((String[])new String[]{"(service.pid=", CETConfiguration.class.getName(), "~", externalReferenceCode, ")"}));
            if (configurations == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)StringBundler.concat((String[])new String[]{"No client extension found with external ", "reference code ", externalReferenceCode}));
                continue;
            }
            Configuration configuration = configurations[0];
            CETConfiguration cetConfiguration = (CETConfiguration)ConfigurableUtil.createConfigurable(CETConfiguration.class, (Dictionary)configuration.getProcessedProperties(null));
            if (_log.isDebugEnabled()) {
                _log.debug((Object)StringBundler.concat((String[])new String[]{"Adding client extension with external reference code ", externalReferenceCode, " to company ", company.getWebId()}));
            }
            this._cetManager.addCET(cetConfiguration, company.getCompanyId(), externalReferenceCode);
        }
        super.portalInstanceRegistered(company);
    }
}

