/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.internal.service.taglib;

import com.liferay.client.extension.internal.service.taglib.util.ClientExtensionDynamicIncludeUtil;
import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.GlobalCSSCET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.portal.kernel.content.security.policy.ContentSecurityPolicyNonceProviderUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.taglib.DynamicInclude;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.vulcan.pagination.Pagination;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DynamicInclude.class})
public class ClientExtensionTopHeadDynamicInclude
implements DynamicInclude {
    private static final Log _log = LogFactoryUtil.getLog(ClientExtensionTopHeadDynamicInclude.class);
    @Reference
    private CETManager _cetManager;

    public void include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String key) throws IOException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PrintWriter printWriter = httpServletResponse.getWriter();
        List<ClientExtensionEntryRel> clientExtensionEntryRels = ClientExtensionDynamicIncludeUtil.getClientExtensionEntryRels(themeDisplay.getLayout(), "globalCSS");
        for (ClientExtensionEntryRel clientExtensionEntryRel : clientExtensionEntryRels) {
            GlobalCSSCET globalCSSCET = (GlobalCSSCET)this._cetManager.getCET(clientExtensionEntryRel.getCompanyId(), clientExtensionEntryRel.getCETExternalReferenceCode());
            if (globalCSSCET == null) continue;
            this._writeStyleSheet(httpServletRequest, printWriter, globalCSSCET.getURL());
        }
        try {
            List cets = this._cetManager.getCETs(themeDisplay.getCompanyId(), null, "globalCSS", Pagination.of((int)-1, (int)-1), null);
            for (CET cet : cets) {
                GlobalCSSCET globalCSSCET = (GlobalCSSCET)cet;
                if (!StringUtil.equalsIgnoreCase((String)globalCSSCET.getScope(), (String)"company")) continue;
                this._writeStyleSheet(httpServletRequest, printWriter, globalCSSCET.getURL());
            }
        }
        catch (Exception exception) {
            _log.error((Object)("Unable to inject CSS client extensions for company " + themeDisplay.getCompanyId()), (Throwable)exception);
        }
    }

    public void register(DynamicInclude.DynamicIncludeRegistry dynamicIncludeRegistry) {
        dynamicIncludeRegistry.register("/html/common/themes/top_head.jsp#post");
    }

    private void _writeStyleSheet(HttpServletRequest httpServletRequest, PrintWriter printWriter, String url) {
        printWriter.print("<link data-senna-track=\"temporary\" href=\"");
        printWriter.print(url);
        printWriter.print("\"");
        printWriter.print(ContentSecurityPolicyNonceProviderUtil.getNonceAttribute((HttpServletRequest)httpServletRequest));
        printWriter.print(" rel=\"stylesheet\" type=\"text/css\" />");
    }
}

