/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.internal.events;

import com.liferay.client.extension.model.ClientExtensionEntryRel;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.type.CET;
import com.liferay.client.extension.type.ThemeCSSCET;
import com.liferay.client.extension.type.ThemeFaviconCET;
import com.liferay.client.extension.type.ThemeSpritemapCET;
import com.liferay.client.extension.type.manager.CETManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.events.Action;
import com.liferay.portal.kernel.events.LifecycleAction;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.model.LayoutSet;
import com.liferay.portal.kernel.service.LayoutLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.Validator;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.List;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"key=servlet.service.events.pre"}, service={LifecycleAction.class})
public class ClientExtensionsServicePreAction
extends Action {
    @Reference
    private CETManager _cetManager;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private LayoutLocalService _layoutLocalService;
    @Reference
    private Portal _portal;

    public void run(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ThemeSpritemapCET themeSpritemapCET;
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Layout layout = this._getLayout(httpServletRequest, themeDisplay);
        if (layout == null) {
            return;
        }
        themeDisplay.setFaviconURL(this._getFaviconURL(layout));
        ThemeCSSCET themeCSSCET = this._getThemeCSSCET(layout);
        if (themeCSSCET != null) {
            if (this._portal.isRightToLeft(httpServletRequest)) {
                themeDisplay.setClayCSSURL(themeCSSCET.getClayRTLURL());
                themeDisplay.setMainCSSURL(themeCSSCET.getMainRTLURL());
            } else {
                themeDisplay.setClayCSSURL(themeCSSCET.getClayURL());
                themeDisplay.setMainCSSURL(themeCSSCET.getMainURL());
            }
        }
        if ((themeSpritemapCET = this._getThemeSpritemapCET(layout)) != null) {
            themeDisplay.setPathThemeSpritemap(themeSpritemapCET.getURL());
        }
    }

    private CET _getCET(long classNameId, long classPK, long companyId, String type) {
        ClientExtensionEntryRel clientExtensionEntryRel = this._clientExtensionEntryRelLocalService.fetchClientExtensionEntryRel(classNameId, classPK, type);
        if (clientExtensionEntryRel == null) {
            return null;
        }
        return this._cetManager.getCET(companyId, clientExtensionEntryRel.getCETExternalReferenceCode());
    }

    private ThemeCSSCET _getControlPanelThemeCSSCET(Layout layout) {
        List clientExtensionEntryRels = this._clientExtensionEntryRelLocalService.getClientExtensionEntryRels(this._portal.getClassNameId(Layout.class), layout.getPlid(), "themeCSS");
        if (clientExtensionEntryRels == null || clientExtensionEntryRels.size() != 1) {
            return null;
        }
        ClientExtensionEntryRel clientExtensionEntryRel = (ClientExtensionEntryRel)clientExtensionEntryRels.get(0);
        return (ThemeCSSCET)this._cetManager.getCET(layout.getCompanyId(), clientExtensionEntryRel.getCETExternalReferenceCode());
    }

    private String _getFaviconURL(Layout layout) {
        Layout masterLayout;
        String faviconURL = this._getThemeFaviconCETURL(this._portal.getClassNameId(Layout.class), layout.getPlid(), layout.getCompanyId());
        if (Validator.isNotNull((String)faviconURL)) {
            return faviconURL;
        }
        faviconURL = layout.getFaviconURL();
        if (Validator.isNotNull((String)faviconURL)) {
            return faviconURL;
        }
        long masterLayoutPlid = layout.getMasterLayoutPlid();
        if (masterLayoutPlid > 0L && (masterLayout = this._layoutLocalService.fetchLayout(masterLayoutPlid)) != null) {
            faviconURL = this._getThemeFaviconCETURL(this._portal.getClassNameId(Layout.class), masterLayout.getPlid(), layout.getCompanyId());
            if (Validator.isNotNull((String)faviconURL)) {
                return faviconURL;
            }
            faviconURL = masterLayout.getFaviconURL();
            if (Validator.isNotNull((String)faviconURL)) {
                return faviconURL;
            }
        }
        LayoutSet layoutSet = layout.getLayoutSet();
        faviconURL = this._getThemeFaviconCETURL(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId(), layout.getCompanyId());
        if (Validator.isNotNull((String)faviconURL)) {
            return faviconURL;
        }
        faviconURL = layoutSet.getFaviconURL();
        if (Validator.isNotNull((String)faviconURL)) {
            return faviconURL;
        }
        return null;
    }

    private Layout _getLayout(HttpServletRequest httpServletRequest, ThemeDisplay themeDisplay) {
        Layout layout = themeDisplay.getLayout();
        if (!layout.isTypeControlPanel()) {
            return layout;
        }
        String mode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_l_mode", (String)"view");
        if (!Objects.equals(mode, "preview")) {
            return layout;
        }
        long selPlid = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)StringBundler.concat((String[])new String[]{"_", ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_p_id"), "_selPlid"}));
        if (selPlid <= 0L) {
            return layout;
        }
        return this._layoutLocalService.fetchLayout(selPlid);
    }

    private ThemeCSSCET _getThemeCSSCET(Layout layout) {
        if (layout.isTypeControlPanel()) {
            return this._getControlPanelThemeCSSCET(layout);
        }
        CET cet = this._getCET(this._portal.getClassNameId(Layout.class), layout.getPlid(), layout.getCompanyId(), "themeCSS");
        if (cet == null && layout.getMasterLayoutPlid() > 0L) {
            cet = this._getCET(this._portal.getClassNameId(Layout.class), layout.getMasterLayoutPlid(), layout.getCompanyId(), "themeCSS");
        }
        if (cet == null) {
            LayoutSet layoutSet = layout.getLayoutSet();
            cet = this._getCET(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId(), layout.getCompanyId(), "themeCSS");
        }
        if (cet != null) {
            return (ThemeCSSCET)cet;
        }
        return null;
    }

    private String _getThemeFaviconCETURL(long classNameId, long classPK, long companyId) {
        CET cet = this._getCET(classNameId, classPK, companyId, "themeFavicon");
        if (cet == null) {
            return null;
        }
        ThemeFaviconCET themeFaviconCET = (ThemeFaviconCET)cet;
        return themeFaviconCET.getURL();
    }

    private ThemeSpritemapCET _getThemeSpritemapCET(Layout layout) {
        CET cet = this._getCET(this._portal.getClassNameId(Layout.class), layout.getPlid(), layout.getCompanyId(), "themeSpritemap");
        if (cet == null && layout.getMasterLayoutPlid() > 0L) {
            cet = this._getCET(this._portal.getClassNameId(Layout.class), layout.getMasterLayoutPlid(), layout.getCompanyId(), "themeSpritemap");
        }
        if (cet == null) {
            LayoutSet layoutSet = layout.getLayoutSet();
            cet = this._getCET(this._portal.getClassNameId(LayoutSet.class), layoutSet.getLayoutSetId(), layout.getCompanyId(), "themeSpritemap");
        }
        if (cet != null) {
            return (ThemeSpritemapCET)cet;
        }
        return null;
    }
}

