/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.client.extension.service.impl;

import com.liferay.client.extension.exception.ClientExtensionEntryNameException;
import com.liferay.client.extension.model.ClientExtensionEntry;
import com.liferay.client.extension.service.ClientExtensionEntryLocalService;
import com.liferay.client.extension.service.ClientExtensionEntryRelLocalService;
import com.liferay.client.extension.service.base.ClientExtensionEntryLocalServiceBaseImpl;
import com.liferay.client.extension.type.deployer.CETDeployer;
import com.liferay.client.extension.type.factory.CETFactory;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cluster.ClusterExecutorUtil;
import com.liferay.portal.kernel.cluster.ClusterInvokeAcceptor;
import com.liferay.portal.kernel.cluster.ClusterNodeResponse;
import com.liferay.portal.kernel.cluster.ClusterRequest;
import com.liferay.portal.kernel.cluster.Clusterable;
import com.liferay.portal.kernel.cluster.ClusterableInvokerUtil;
import com.liferay.portal.kernel.cluster.FutureClusterResponses;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.MethodHandler;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.UnicodePropertiesBuilder;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowHandlerRegistryUtil;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.client.extension.model.ClientExtensionEntry"}, service={AopService.class})
public class ClientExtensionEntryLocalServiceImpl
extends ClientExtensionEntryLocalServiceBaseImpl {
    private static final long _CLUSTER_TIMEOUT = 10000L;
    private static final Log _log = LogFactoryUtil.getLog(ClientExtensionEntryLocalServiceImpl.class);
    private static final Method _undeployClientExtensionEntryMethod;
    @Reference
    private CETDeployer _cetDeployer;
    @Reference
    private CETFactory _cetFactory;
    @Reference
    private ClientExtensionEntryRelLocalService _clientExtensionEntryRelLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    private final Map<Long, List<ServiceRegistration<?>>> _serviceRegistrationsMap = new ConcurrentHashMap();
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry addClientExtensionEntry(String externalReferenceCode, long userId, String description, Map<Locale, String> nameMap, String properties, String sourceCodeURL, String type, String typeSettings) throws PortalException {
        this._validateName(nameMap);
        User user = this._userLocalService.getUser(userId);
        this._validateTypeSettings(user.getCompanyId(), typeSettings, null, type);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.create(this.counterLocalService.increment());
        clientExtensionEntry.setExternalReferenceCode(externalReferenceCode);
        clientExtensionEntry.setCompanyId(user.getCompanyId());
        clientExtensionEntry.setUserId(user.getUserId());
        clientExtensionEntry.setUserName(user.getFullName());
        clientExtensionEntry.setDescription(description);
        clientExtensionEntry.setNameMap(nameMap);
        clientExtensionEntry.setProperties(properties);
        clientExtensionEntry.setSourceCodeURL(sourceCodeURL);
        clientExtensionEntry.setType(type);
        clientExtensionEntry.setTypeSettings(typeSettings);
        clientExtensionEntry.setStatus(2);
        clientExtensionEntry.setStatusByUserId(userId);
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        this._addResources(clientExtensionEntry);
        return this._startWorkflowInstance(userId, clientExtensionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry addOrUpdateClientExtensionEntry(String externalReferenceCode, long userId, String description, Map<Locale, String> nameMap, String properties, String sourceCodeURL, String type, String typeSettings) throws PortalException {
        User user = this._userLocalService.getUser(userId);
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryLocalService.fetchClientExtensionEntryByExternalReferenceCode(externalReferenceCode, user.getCompanyId());
        if (clientExtensionEntry != null) {
            return this.updateClientExtensionEntry(userId, clientExtensionEntry.getClientExtensionEntryId(), description, nameMap, properties, sourceCodeURL, typeSettings);
        }
        return this.addClientExtensionEntry(externalReferenceCode, userId, description, nameMap, properties, sourceCodeURL, type, typeSettings);
    }

    @Override
    @SystemEvent(type=1)
    public ClientExtensionEntry deleteClientExtensionEntry(ClientExtensionEntry clientExtensionEntry) throws PortalException {
        this.clientExtensionEntryPersistence.remove((BaseModel)clientExtensionEntry);
        this._resourceLocalService.deleteResource(clientExtensionEntry.getCompanyId(), ClientExtensionEntry.class.getName(), 4, clientExtensionEntry.getClientExtensionEntryId());
        this._clientExtensionEntryRelLocalService.deleteClientExtensionEntryRels(clientExtensionEntry.getCompanyId(), clientExtensionEntry.getExternalReferenceCode());
        this.clientExtensionEntryLocalService.undeployClientExtensionEntry(clientExtensionEntry);
        return clientExtensionEntry;
    }

    @Override
    public ClientExtensionEntry deleteClientExtensionEntry(long clientExtensionEntryId) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        return this.deleteClientExtensionEntry(clientExtensionEntry);
    }

    @Clusterable
    public void deployClientExtensionEntry(ClientExtensionEntry clientExtensionEntry) throws PortalException {
        try {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Deploying client extension entry " + clientExtensionEntry.getName(LocaleUtil.getDefault())));
            }
            this.undeployClientExtensionEntry(clientExtensionEntry);
            List serviceRegistrations = this._cetDeployer.deploy(this._cetFactory.create(clientExtensionEntry, true));
            if (_log.isInfoEnabled()) {
                for (ServiceRegistration serviceRegistration : serviceRegistrations) {
                    _log.info((Object)("Registered " + String.valueOf(serviceRegistration)));
                }
            }
            this._serviceRegistrationsMap.put(clientExtensionEntry.getClientExtensionEntryId(), serviceRegistrations);
        }
        catch (PortalException | RuntimeException exception) {
            _log.error((Object)("Unable to deploy client extension entry " + clientExtensionEntry.getName(LocaleUtil.getDefault())), exception);
            throw exception;
        }
        finally {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Finished deploying client extension entry " + clientExtensionEntry.getName(LocaleUtil.getDefault())));
            }
        }
    }

    public List<ClientExtensionEntry> getClientExtensionEntries(long companyId, int start, int end) {
        return this.clientExtensionEntryPersistence.findByCompanyId(companyId, start, end);
    }

    public List<ClientExtensionEntry> getClientExtensionEntries(long companyId, String type, int start, int end) {
        return this.clientExtensionEntryPersistence.findByC_T(companyId, type, start, end);
    }

    public int getClientExtensionEntriesCount(long companyId) {
        return this.clientExtensionEntryPersistence.countByCompanyId(companyId);
    }

    public int getClientExtensionEntriesCount(long companyId, String type) {
        return this.clientExtensionEntryPersistence.countByC_T(companyId, type);
    }

    public List<ClientExtensionEntry> search(long companyId, String keywords, int start, int end, Sort sort) throws PortalException {
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, start, end, sort);
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ClientExtensionEntry.class);
        for (int i = 0; i < 10; ++i) {
            Hits hits = indexer.search(searchContext);
            List<ClientExtensionEntry> clientExtensionEntries = this._getClientExtensionEntries(hits);
            if (clientExtensionEntries == null) continue;
            return clientExtensionEntries;
        }
        throw new SearchException("Unable to fix the search index after 10 attempts");
    }

    public int searchCount(long companyId, String keywords) throws PortalException {
        Indexer indexer = IndexerRegistryUtil.nullSafeGetIndexer(ClientExtensionEntry.class);
        SearchContext searchContext = this._buildSearchContext(companyId, keywords, -1, -1, null);
        return GetterUtil.getInteger((Object)indexer.searchCount(searchContext));
    }

    @Override
    public void setAopProxy(Object aopProxy) {
        super.setAopProxy(aopProxy);
        this._companyLocalService.forEachCompanyId(companyId -> {
            List clientExtensionEntries = this.clientExtensionEntryLocalService.getClientExtensionEntries(companyId.longValue(), -1, -1);
            for (ClientExtensionEntry clientExtensionEntry : clientExtensionEntries) {
                try {
                    this.deployClientExtensionEntry(clientExtensionEntry);
                }
                catch (PortalException portalException) {
                    ReflectionUtil.throwException((Throwable)portalException);
                }
            }
        });
    }

    @Clusterable
    public void undeployClientExtensionEntry(ClientExtensionEntry clientExtensionEntry) {
        try {
            List<ServiceRegistration<?>> serviceRegistrations;
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Undeploying client extension entry " + clientExtensionEntry.getName(LocaleUtil.getDefault())));
            }
            if ((serviceRegistrations = this._serviceRegistrationsMap.remove(clientExtensionEntry.getClientExtensionEntryId())) != null) {
                for (ServiceRegistration<?> serviceRegistration : serviceRegistrations) {
                    if (_log.isInfoEnabled()) {
                        _log.info((Object)("Unregistering " + String.valueOf(serviceRegistration)));
                    }
                    serviceRegistration.unregister();
                }
            }
        }
        catch (RuntimeException runtimeException) {
            _log.error((Object)("Unable to undeploy client extension entry " + clientExtensionEntry.getName(LocaleUtil.getDefault())), (Throwable)runtimeException);
            throw runtimeException;
        }
        finally {
            if (_log.isInfoEnabled()) {
                _log.info((Object)("Finished undeploying client extension entry " + clientExtensionEntry.getName(LocaleUtil.getDefault())));
            }
        }
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry updateClientExtensionEntry(long userId, long clientExtensionEntryId, String description, Map<Locale, String> nameMap, String properties, String sourceCodeURL, String typeSettings) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        this._validateTypeSettings(clientExtensionEntry.getCompanyId(), typeSettings, clientExtensionEntry.getTypeSettings(), clientExtensionEntry.getType());
        this.undeployClientExtensionEntry(clientExtensionEntry);
        try {
            this._synchronousInvokeOnCluster(ClusterInvokeAcceptor.class, (Object)this, _undeployClientExtensionEntryMethod, new Object[]{clientExtensionEntry}, 10000L, TimeUnit.MILLISECONDS);
        }
        catch (Throwable throwable) {
            throw new PortalException("Unable to undeploy client extension entry across the cluster", throwable);
        }
        clientExtensionEntry.setDescription(description);
        clientExtensionEntry.setNameMap(nameMap);
        clientExtensionEntry.setProperties(properties);
        clientExtensionEntry.setSourceCodeURL(sourceCodeURL);
        clientExtensionEntry.setTypeSettings(typeSettings);
        clientExtensionEntry.setStatus(2);
        clientExtensionEntry.setStatusByUserId(userId);
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        return this._startWorkflowInstance(userId, clientExtensionEntry);
    }

    @Indexable(type=IndexableType.REINDEX)
    public ClientExtensionEntry updateStatus(long userId, long clientExtensionEntryId, int status) throws PortalException {
        ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.findByPrimaryKey(clientExtensionEntryId);
        int oldStatus = clientExtensionEntry.getStatus();
        if (_log.isInfoEnabled()) {
            _log.info((Object)StringBundler.concat((Object[])new Object[]{"Updating workflow status for client extension entry ", clientExtensionEntry.getName(LocaleUtil.getDefault()), " from ", oldStatus, " to ", status}));
        }
        if (status == oldStatus) {
            return clientExtensionEntry;
        }
        User user = this._userLocalService.getUser(userId);
        clientExtensionEntry.setStatus(status);
        clientExtensionEntry.setStatusByUserId(user.getUserId());
        clientExtensionEntry.setStatusByUserName(user.getFullName());
        clientExtensionEntry.setStatusDate(new Date());
        clientExtensionEntry = (ClientExtensionEntry)this.clientExtensionEntryPersistence.update((BaseModel)clientExtensionEntry);
        if (status == 0) {
            this.clientExtensionEntryLocalService.deployClientExtensionEntry(clientExtensionEntry);
        } else if (oldStatus == 0) {
            this.clientExtensionEntryLocalService.undeployClientExtensionEntry(clientExtensionEntry);
        }
        return clientExtensionEntry;
    }

    private void _addResources(ClientExtensionEntry clientExtensionEntry) throws PortalException {
        this._resourceLocalService.addResources(clientExtensionEntry.getCompanyId(), 0L, clientExtensionEntry.getUserId(), ClientExtensionEntry.class.getName(), clientExtensionEntry.getClientExtensionEntryId(), false, true, true);
    }

    private SearchContext _buildSearchContext(long companyId, String keywords, int start, int end, Sort sort) {
        SearchContext searchContext = new SearchContext();
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setHighlightEnabled(false);
        queryConfig.setScoreEnabled(false);
        searchContext.setAttributes((Map)HashMapBuilder.put((Object)"name", (Object)keywords).put((Object)"url", (Object)keywords).build());
        searchContext.setCompanyId(companyId);
        searchContext.setEnd(end);
        searchContext.setKeywords(keywords);
        if (sort != null) {
            searchContext.setSorts(new Sort[]{sort});
        }
        searchContext.setStart(start);
        return searchContext;
    }

    private List<ClientExtensionEntry> _getClientExtensionEntries(Hits hits) throws PortalException {
        List documents = hits.toList();
        ArrayList<ClientExtensionEntry> clientExtensionEntries = new ArrayList<ClientExtensionEntry>(documents.size());
        for (Document document : documents) {
            long clientExtensionEntryId = GetterUtil.getLong((String)document.get("entryClassPK"));
            ClientExtensionEntry clientExtensionEntry = this.clientExtensionEntryPersistence.fetchByPrimaryKey(clientExtensionEntryId);
            if (clientExtensionEntry == null) {
                clientExtensionEntries = null;
                Indexer indexer = IndexerRegistryUtil.getIndexer(ClientExtensionEntry.class);
                long companyId = GetterUtil.getLong((String)document.get("companyId"));
                indexer.delete(companyId, document.getUID());
                continue;
            }
            clientExtensionEntries.add(clientExtensionEntry);
        }
        return clientExtensionEntries;
    }

    private ClientExtensionEntry _startWorkflowInstance(long userId, ClientExtensionEntry clientExtensionEntry) throws PortalException {
        Company company = this._companyLocalService.getCompany(clientExtensionEntry.getCompanyId());
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        return (ClientExtensionEntry)WorkflowHandlerRegistryUtil.startWorkflowInstance((long)clientExtensionEntry.getCompanyId(), (long)company.getGroupId(), (long)userId, (String)ClientExtensionEntry.class.getName(), (long)clientExtensionEntry.getClientExtensionEntryId(), (Object)clientExtensionEntry, (ServiceContext)serviceContext, new HashMap());
    }

    private void _synchronousInvokeOnCluster(Class<? extends ClusterInvokeAcceptor> clusterInvokeAcceptorClass, Object targetObject, Method method, Object[] arguments, long timeout, TimeUnit timeoutUnit) throws Throwable {
        if (!ClusterExecutorUtil.isEnabled()) {
            return;
        }
        MethodHandler methodHandler = ClusterableInvokerUtil.createMethodHandler(clusterInvokeAcceptorClass, (Object)targetObject, (Method)method, (Object[])arguments);
        ClusterRequest clusterRequest = ClusterRequest.createMulticastRequest((Serializable)methodHandler, (boolean)true);
        FutureClusterResponses futureClusterResponses = ClusterExecutorUtil.execute((ClusterRequest)clusterRequest);
        if (futureClusterResponses == null) {
            return;
        }
        BlockingQueue clusterNodeResponses = futureClusterResponses.getPartialResults();
        while (!clusterNodeResponses.isEmpty() || !futureClusterResponses.isDone()) {
            ClusterNodeResponse clusterNodeResponse = (ClusterNodeResponse)clusterNodeResponses.poll(timeout, timeoutUnit);
            if (clusterNodeResponse == null) {
                throw new TimeoutException("Timeout waiting for undeployment in the cluster");
            }
            Exception exception = clusterNodeResponse.getException();
            if (exception == null) continue;
            throw exception;
        }
    }

    private void _validateName(Map<Locale, String> nameMap) throws PortalException {
        if (Validator.isBlank((String)nameMap.get(LocaleUtil.getDefault()))) {
            throw new ClientExtensionEntryNameException();
        }
    }

    private void _validateTypeSettings(long companyId, String newTypeSettings, String oldTypeSettings, String type) throws PortalException {
        UnicodeProperties newTypeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).load(newTypeSettings).build();
        UnicodeProperties oldTypeSettingsUnicodeProperties = null;
        if (oldTypeSettings != null) {
            oldTypeSettingsUnicodeProperties = UnicodePropertiesBuilder.create((boolean)true).load(oldTypeSettings).build();
        }
        this._cetFactory.validate(companyId, newTypeSettingsUnicodeProperties, oldTypeSettingsUnicodeProperties, type);
    }

    static {
        try {
            _undeployClientExtensionEntryMethod = ClientExtensionEntryLocalService.class.getMethod("undeployClientExtensionEntry", ClientExtensionEntry.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            _log.error((Object)"Unable to get undeployClientExtensionEntry method", (Throwable)noSuchMethodException);
            throw new RuntimeException(noSuchMethodException);
        }
    }
}

