/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.configuration.CTSettingsConfiguration;
import com.liferay.change.tracking.model.CTSchemaVersion;
import com.liferay.change.tracking.service.base.CTSchemaVersionLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.Release;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ReleaseLocalService;
import com.liferay.portal.kernel.version.Version;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.change.tracking.configuration.CTSettingsConfiguration"}, property={"model.class.name=com.liferay.change.tracking.model.CTSchemaVersion"}, service={AopService.class})
public class CTSchemaVersionLocalServiceImpl
extends CTSchemaVersionLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CTSchemaVersionLocalServiceImpl.class);
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private ReleaseLocalService _releaseLocalService;

    public CTSchemaVersion addLatestCTSchemaVersion(long companyId) {
        CTSchemaVersion ctSchemaVersion = this.ctSchemaVersionPersistence.create(this.counterLocalService.increment(CTSchemaVersion.class.getName()));
        ctSchemaVersion.setCompanyId(companyId);
        HashMap<String, String> schemaContext = new HashMap<String, String>();
        for (Release release : this._releaseLocalService.getReleases(-1, -1)) {
            schemaContext.put(release.getServletContextName(), release.getSchemaVersion());
        }
        ctSchemaVersion.setSchemaContext(schemaContext);
        return (CTSchemaVersion)this.ctSchemaVersionPersistence.update((BaseModel)ctSchemaVersion);
    }

    public CTSchemaVersion getLatestCTSchemaVersion(long companyId) {
        CTSchemaVersion ctSchemaVersion = this.ctSchemaVersionPersistence.fetchByCompanyId_First(companyId, null);
        if (ctSchemaVersion == null || !this.isLatestCTSchemaVersion(ctSchemaVersion, true)) {
            ctSchemaVersion = this.ctSchemaVersionLocalService.addLatestCTSchemaVersion(companyId);
        }
        return ctSchemaVersion;
    }

    public boolean isLatestCTSchemaVersion(CTSchemaVersion ctSchemaVersion, boolean strict) {
        try {
            CTSettingsConfiguration ctSettingsConfiguration = (CTSettingsConfiguration)this._configurationProvider.getCompanyConfiguration(CTSettingsConfiguration.class, CompanyThreadLocal.getCompanyId().longValue());
            if (!ctSettingsConfiguration.schemaVersionCheckEnabled()) {
                return true;
            }
        }
        catch (ConfigurationException configurationException) {
            _log.error((Throwable)configurationException);
        }
        if (ctSchemaVersion == null) {
            return false;
        }
        Map schemaContext = ctSchemaVersion.getSchemaContext();
        List releases = this._releaseLocalService.getReleases(-1, -1);
        if (releases.size() != schemaContext.size()) {
            this.ctSchemaVersionLocalService.addLatestCTSchemaVersion(ctSchemaVersion.getCompanyId());
            return false;
        }
        for (Release release : releases) {
            String ctReleaseSchemaVersion = (String)schemaContext.get(release.getServletContextName());
            if (Objects.equals(ctReleaseSchemaVersion, release.getSchemaVersion())) continue;
            if (strict) {
                return false;
            }
            Version version1 = Version.parseVersion((String)ctReleaseSchemaVersion);
            Version version2 = Version.parseVersion((String)release.getSchemaVersion());
            if (version1.getMajor() == version2.getMajor() && version1.getMinor() == version2.getMinor()) continue;
            return false;
        }
        return true;
    }

    public boolean isLatestCTSchemaVersion(long ctSchemaVersionId) {
        CTSchemaVersion ctSchemaVersion = this.ctSchemaVersionPersistence.fetchByPrimaryKey(ctSchemaVersionId);
        return this.isLatestCTSchemaVersion(ctSchemaVersion, false);
    }
}

