/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTMessage;
import com.liferay.change.tracking.service.base.CTMessageLocalServiceBaseImpl;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.json.JSONFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.Collection;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(property={"model.class.name=com.liferay.change.tracking.model.CTMessage"}, service={AopService.class})
public class CTMessageLocalServiceImpl
extends CTMessageLocalServiceBaseImpl {
    @Reference
    private JSONFactory _jsonFactory;

    public CTMessage addCTMessage(long ctCollectionId, Message message) {
        long ctMessageId = this.counterLocalService.increment(CTMessage.class.getName());
        CTMessage ctMessage = this.ctMessagePersistence.create(ctMessageId);
        ctMessage.setCtCollectionId(ctCollectionId);
        message = message.clone();
        message.remove("companyId");
        ctMessage.setMessageContent(this._jsonFactory.serialize((Object)message));
        return (CTMessage)this.ctMessagePersistence.update((BaseModel)ctMessage);
    }

    public List<Message> getMessages(long ctCollectionId) {
        return TransformUtil.transform((Collection)this.ctMessagePersistence.findByCtCollectionId(ctCollectionId), ctMessage -> {
            Message message = (Message)this._jsonFactory.deserialize(ctMessage.getMessageContent());
            message.put("companyId", (Object)ctMessage.getCompanyId());
            return message;
        });
    }
}

