/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.configuration.helper.CTSettingsConfigurationHelper;
import com.liferay.change.tracking.exception.CTCollectionDescriptionException;
import com.liferay.change.tracking.exception.CTCollectionNameException;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTemplate;
import com.liferay.change.tracking.service.base.CTCollectionTemplateLocalServiceBaseImpl;
import com.liferay.json.storage.service.JSONStorageEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.DigesterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.Validator;
import java.time.Instant;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTCollectionTemplate"}, service={AopService.class})
public class CTCollectionTemplateLocalServiceImpl
extends CTCollectionTemplateLocalServiceBaseImpl {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTSettingsConfigurationHelper _ctSettingsConfigurationHelper;
    @Reference
    private JSONStorageEntryLocalService _jsonStorageEntryLocalService;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public CTCollectionTemplate addCTCollectionTemplate(long userId, String name, String description, String json) throws PortalException {
        this._validate(name, description);
        long ctCollectionTemplateId = this.counterLocalService.increment(CTCollectionTemplate.class.getName());
        CTCollectionTemplate ctCollectionTemplate = this.ctCollectionTemplatePersistence.create(ctCollectionTemplateId);
        User user = this._userLocalService.getUser(userId);
        ctCollectionTemplate.setCompanyId(user.getCompanyId());
        ctCollectionTemplate.setUserId(userId);
        ctCollectionTemplate.setName(name);
        ctCollectionTemplate.setDescription(description);
        ctCollectionTemplate = (CTCollectionTemplate)this.ctCollectionTemplatePersistence.update((BaseModel)ctCollectionTemplate);
        this._resourceLocalService.addResources(ctCollectionTemplate.getCompanyId(), 0L, ctCollectionTemplate.getUserId(), CTCollectionTemplate.class.getName(), ctCollectionTemplate.getCtCollectionTemplateId(), false, false, false);
        this._jsonStorageEntryLocalService.addJSONStorageEntries(user.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollectionTemplate.class.getName()), ctCollectionTemplateId, json);
        return ctCollectionTemplate;
    }

    @Override
    public CTCollectionTemplate deleteCTCollectionTemplate(CTCollectionTemplate ctCollectionTemplate) throws PortalException {
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        if (this._ctSettingsConfigurationHelper.isDefaultCTCollectionTemplate(ctCollectionTemplate.getCompanyId(), ctCollectionTemplate.getCtCollectionTemplateId())) {
            properties.put("defaultCTCollectionTemplateId", 0);
        }
        if (this._ctSettingsConfigurationHelper.isDefaultSandboxCTCollectionTemplate(ctCollectionTemplate.getCompanyId(), ctCollectionTemplate.getCtCollectionTemplateId())) {
            properties.put("defaultSandboxCTCollectionTemplateId", 0);
        }
        if (!properties.isEmpty()) {
            this._ctSettingsConfigurationHelper.save(ctCollectionTemplate.getCompanyId(), properties);
        }
        this.ctCollectionTemplatePersistence.remove((BaseModel)ctCollectionTemplate);
        this._resourceLocalService.deleteResource(ctCollectionTemplate.getCompanyId(), CTCollectionTemplate.class.getName(), 4, ctCollectionTemplate.getCtCollectionTemplateId());
        return ctCollectionTemplate;
    }

    @Override
    public CTCollectionTemplate deleteCTCollectionTemplate(long ctCollectionTemplateId) throws PortalException {
        return this.deleteCTCollectionTemplate(this.fetchCTCollectionTemplate(ctCollectionTemplateId));
    }

    @Override
    public CTCollectionTemplate fetchCTCollectionTemplate(long ctCollectionTemplateId) {
        return this.ctCollectionTemplatePersistence.fetchByPrimaryKey(ctCollectionTemplateId);
    }

    public List<CTCollectionTemplate> getCTCollectionTemplates(long companyId, int start, int end) {
        return this.ctCollectionTemplatePersistence.findByCompanyId(companyId, start, end);
    }

    public Set<String> getTokens() {
        Map<String, String> tokensMap = this._getTokensMap(0L);
        return tokensMap.keySet();
    }

    public String parseTokens(long ctCollectionTemplateId, String s) {
        if (s.contains("${")) {
            StringBundler sb = new StringBundler();
            int current = 0;
            Map<String, String> tokensMap = this._getTokensMap(ctCollectionTemplateId);
            while (current < s.length()) {
                int x = s.indexOf("${", current);
                if (x == -1) {
                    sb.append(s.substring(current));
                    break;
                }
                int y = s.indexOf("}", x);
                sb.append(s.substring(current, x));
                String token = s.substring(x, y + 1);
                sb.append(tokensMap.get(token));
                current = y + 1;
            }
            return sb.toString();
        }
        return s;
    }

    public CTCollectionTemplate updateCTCollectionTemplate(long ctCollectionTemplateId, String name, String description, String json) throws PortalException {
        this._validate(name, description);
        CTCollectionTemplate ctCollectionTemplate = this.ctCollectionTemplatePersistence.findByPrimaryKey(ctCollectionTemplateId);
        ctCollectionTemplate.setName(name);
        ctCollectionTemplate.setDescription(description);
        ctCollectionTemplate = (CTCollectionTemplate)this.ctCollectionTemplatePersistence.update((BaseModel)ctCollectionTemplate);
        this._jsonStorageEntryLocalService.updateJSONStorageEntries(ctCollectionTemplate.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollectionTemplate.class.getName()), ctCollectionTemplateId, json);
        return ctCollectionTemplate;
    }

    private Map<String, String> _getTokensMap(long ctCollectionTemplateId) {
        return HashMapBuilder.put((Object)"${CURRENT_USERNAME}", () -> {
            ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
            User user = this._userLocalService.fetchUser(serviceContext.getUserId());
            if (user != null) {
                return user.getScreenName();
            }
            return "";
        }).put((Object)"${RANDOM_HASH}", () -> {
            Instant now = Instant.now();
            return DigesterUtil.digestHex((String)"MD5", (String[])new String[]{String.valueOf(ctCollectionTemplateId), String.valueOf(now.getEpochSecond())});
        }).put((Object)"${TODAY_DATE}", (Object)String.valueOf(LocalDate.now())).build();
    }

    private void _validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CTCollectionNameException();
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new CTCollectionNameException("Name is too long");
        }
        int descriptionMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"description");
        if (description != null && description.length() > descriptionMaxLength) {
            throw new CTCollectionDescriptionException("Description is too long");
        }
    }
}

