/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.util;

import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.internal.conflict.MissingRequirementConflictInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTSchemaVersion;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTSchemaVersionHelper.class})
public class CTSchemaVersionHelper {
    private static final Log _log = LogFactoryUtil.getLog(CTSchemaVersionHelper.class);
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;

    public void expireCTCollection(CTCollection ctCollection) {
        if (this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(ctCollection.getSchemaVersionId())) {
            return;
        }
        try {
            Map conflictMap = this._ctCollectionLocalService.checkConflicts(ctCollection);
            for (Map.Entry entry : conflictMap.entrySet()) {
                List conflictInfos = (List)entry.getValue();
                for (ConflictInfo conflictInfo : conflictInfos) {
                    if (!(conflictInfo instanceof MissingRequirementConflictInfo)) continue;
                    ctCollection.setStatus(3);
                    ctCollection = this._ctCollectionLocalService.updateCTCollection(ctCollection);
                    return;
                }
            }
            CTSchemaVersion ctSchemaVersion = this._ctSchemaVersionLocalService.getLatestCTSchemaVersion(ctCollection.getCompanyId());
            ctCollection.setSchemaVersionId(ctSchemaVersion.getSchemaVersionId());
            ctCollection = this._ctCollectionLocalService.updateCTCollection(ctCollection);
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)portalException);
            }
            ctCollection.setStatus(3);
            this._ctCollectionLocalService.updateCTCollection(ctCollection);
        }
    }

    public void expireCTCollections() {
        for (CTCollection ctCollection : (List)this._ctCollectionLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).where(CTCollectionTable.INSTANCE.status.eq((Object)2)))) {
            this.expireCTCollection(ctCollection);
        }
    }
}

