/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.servlet.filter;

import com.liferay.change.tracking.exception.NoSuchCollectionException;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.portal.kernel.change.tracking.CTCollectionPreviewThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactory;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.util.HttpComponentsUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.servlet.filters.BasePortalFilter;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"dispatcher=FORWARD", "dispatcher=REQUEST", "servlet-context-name=", "servlet-filter-name=CTCollection Preview Filter", "url-pattern=/*"}, service={Filter.class})
public class CTCollectionPreviewFilter
extends BasePortalFilter {
    @Reference
    protected PermissionCheckerFactory permissionCheckerFactory;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference(target="(model.class.name=com.liferay.change.tracking.model.CTCollection)")
    private ModelResourcePermission<CTCollection> _modelResourcePermission;
    @Reference
    private Portal _portal;

    protected void processFilter(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FilterChain filterChain) throws Exception {
        long previewCTCollectionId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"previewCTCollectionId", (long)-1L);
        if (previewCTCollectionId == -1L) {
            this.processFilter(CTCollectionPreviewFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
            return;
        }
        String mode = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"p_l_mode");
        if (!mode.equals("preview")) {
            httpServletResponse.sendRedirect(HttpComponentsUtil.addParameter((String)this._portal.getCurrentURL(httpServletRequest), (String)"p_l_mode", (String)"preview"));
            return;
        }
        if (previewCTCollectionId != 0L) {
            CTCollection ctCollection = this._ctCollectionLocalService.fetchCTCollection(previewCTCollectionId);
            if (ctCollection == null) {
                this._portal.sendError((Exception)new NoSuchCollectionException(), httpServletRequest, httpServletResponse);
                return;
            }
            if (ctCollection.getStatus() != 0 && ctCollection.getStatus() != 2 && ctCollection.getStatus() != 3 && ctCollection.getStatus() != 1 && ctCollection.getStatus() != 7) {
                this._portal.sendError((Exception)((Object)new PortalException("Collection is not available")), httpServletRequest, httpServletResponse);
                return;
            }
            PermissionChecker permissionChecker = PermissionThreadLocal.getPermissionChecker();
            if (permissionChecker == null) {
                permissionChecker = this.permissionCheckerFactory.create(this._portal.getUser(httpServletRequest));
            }
            if (!this._modelResourcePermission.contains(permissionChecker, (ClassedModel)ctCollection, "VIEW")) {
                this._portal.sendError((Exception)new PrincipalException.MustHavePermission(permissionChecker, CTCollection.class.getName(), previewCTCollectionId, new String[]{"VIEW"}), httpServletRequest, httpServletResponse);
                return;
            }
        }
        CTCollectionPreviewThreadLocal.setCTCollectionId((long)previewCTCollectionId);
        CTCollectionPreviewThreadLocal.setIndicatorEnabled((boolean)ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"previewCTIndicator"));
        this.processFilter(CTCollectionPreviewFilter.class.getName(), httpServletRequest, httpServletResponse, filterChain);
    }
}

