/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.security.permission.resource;

import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTProcess"}, service={ModelResourcePermission.class})
public class CTProcessModelResourcePermission
implements ModelResourcePermission<CTProcess> {
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTProcessLocalService _ctProcessLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference(target="(resource.name=com.liferay.change.tracking)")
    private PortletResourcePermission _portletResourcePermission;

    public void check(PermissionChecker permissionChecker, CTProcess ctProcess, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctProcess, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTProcess.class.getName(), ctProcess.getCtProcessId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long ctProcessId, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, ctProcessId, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, CTProcess.class.getName(), ctProcessId, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, CTProcess ctProcess, String actionId) {
        if (permissionChecker.hasOwnerPermission(ctProcess.getCompanyId(), CTProcess.class.getName(), ctProcess.getCtProcessId(), ctProcess.getUserId(), actionId)) {
            return true;
        }
        Group group = this._groupLocalService.fetchGroup(ctProcess.getCompanyId(), this._classNameLocalService.getClassNameId(CTProcess.class), ctProcess.getCtProcessId());
        return permissionChecker.hasPermission(group, CTProcess.class.getName(), ctProcess.getCtProcessId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long ctProcessId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._ctProcessLocalService.getCTProcess(ctProcessId), actionId);
    }

    public String getModelName() {
        return CTProcess.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return this._portletResourcePermission;
    }
}

