/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.on.demand.user.ticket.generator;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.on.demand.user.ticket.generator.CTOnDemandUserTicketGenerator;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.audit.AuditMessage;
import com.liferay.portal.kernel.audit.AuditRouter;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.Ticket;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.TicketLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.PwdGenerator;
import com.liferay.portal.security.audit.event.generators.util.AuditMessageBuilder;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTOnDemandUserTicketGenerator.class})
public class CTOnDemandUserTicketGeneratorImpl
implements CTOnDemandUserTicketGenerator {
    private static final Log _log = LogFactoryUtil.getLog(CTOnDemandUserTicketGeneratorImpl.class);
    @Reference
    private AuditRouter _auditRouter;
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private CTCollectionLocalService _ctCollectionLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TicketLocalService _ticketLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserLocalService _userLocalService;

    public Ticket generate(long ctCollectionId) throws PortalException {
        User user;
        CTCollection ctCollection;
        block11: {
            ctCollection = this._ctCollectionLocalService.fetchCTCollection(ctCollectionId);
            if (ctCollection == null || !ctCollection.isShareable()) {
                return null;
            }
            List tickets = this._ticketLocalService.getTickets(ctCollection.getCompanyId(), CTCollection.class.getName(), ctCollectionId, 5);
            if (!tickets.isEmpty()) {
                return (Ticket)tickets.get(0);
            }
            user = null;
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                user = this._getCTOnDemandUser(ctCollection);
            }
            catch (PortalException portalException) {
                if (!_log.isDebugEnabled()) break block11;
                _log.debug((Throwable)portalException);
            }
        }
        if (user == null) {
            return null;
        }
        AuditMessage auditMessage = AuditMessageBuilder.buildAuditMessage((String)"CT_ON_DEMAND_USER_TICKET_GENERATED", (String)CTCollection.class.getName(), (long)ctCollectionId, null);
        auditMessage.setAdditionalInfo(JSONUtil.put((String)"companyId", (Object)ctCollection.getCompanyId()).put("onDemandUserId", user.getUserId()));
        this._auditRouter.route(auditMessage);
        return this._ticketLocalService.addDistinctTicket(user.getCompanyId(), CTCollection.class.getName(), ctCollectionId, 5, String.valueOf(user.getUserId()), null, null);
    }

    private User _getCTOnDemandUser(CTCollection ctCollection) throws PortalException {
        User user = this._userLocalService.fetchUserById(ctCollection.getOnDemandUserId());
        if (user != null) {
            return user;
        }
        Company company = this._companyLocalService.getCompany(ctCollection.getCompanyId());
        String screenName = StringBundler.concat((Object[])new Object[]{"ct_on_demand_user", "_", ctCollection.getCtCollectionId()});
        String password = PwdGenerator.getPassword((int)20);
        Date date = new Date();
        Role role = this._roleLocalService.getRole(ctCollection.getCompanyId(), "Publications Reviewer");
        user = this._userLocalService.addUser(PrincipalThreadLocal.getUserId(), company.getCompanyId(), false, password, password, true, screenName, StringBundler.concat((String[])new String[]{screenName, "@", company.getMx()}), company.getLocale(), ctCollection.getName(), null, "Publication Reviewer", 0L, 0L, true, date.getMonth(), date.getDate(), date.getYear(), null, 4, null, null, new long[]{role.getRoleId()}, null, false, new ServiceContext());
        user.setPasswordReset(false);
        user.setAgreedToTermsOfUse(true);
        user.setEmailAddressVerified(true);
        user = this._userLocalService.updateUser(user);
        ctCollection.setOnDemandUserId(user.getUserId());
        ctCollection = this._ctCollectionLocalService.updateCTCollection(ctCollection);
        Group group = this._groupLocalService.fetchGroup(ctCollection.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollection.class), ctCollection.getCtCollectionId());
        if (group == null) {
            group = this._groupLocalService.addGroup("", ctCollection.getUserId(), 0L, CTCollection.class.getName(), ctCollection.getCtCollectionId(), 0L, (Map)HashMapBuilder.put((Object)LocaleUtil.getDefault(), (Object)ctCollection.getName()).build(), null, 3, null, false, 0, null, false, false, true, null);
        }
        this._userGroupRoleLocalService.addUserGroupRole(user.getUserId(), group.getGroupId(), role.getRoleId());
        return user;
    }
}

