/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.messaging;

import com.liferay.change.tracking.internal.score.CTScoreCalculator;
import com.liferay.change.tracking.service.CTScoreLocalService;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.util.MapUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/ct_score"}, service={MessageListener.class})
public class CTScoreMessageListener
extends BaseMessageListener {
    @Reference
    private CTScoreCalculator _ctScoreCalculator;
    @Reference
    private CTScoreLocalService _ctScoreLocalService;
    @Reference
    private DestinationFactory _destinationFactory;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("serial", "liferay/ct_score");
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        this._serviceRegistration.unregister();
    }

    protected void doReceive(Message message) throws Exception {
        if (message.getBoolean("increment")) {
            this._ctScoreLocalService.incrementScore(message.getLong("ctCollectionId"), this._ctScoreCalculator.calculate(message.getLong("modelClassNameId")));
        } else {
            this._ctScoreLocalService.decrementScore(message.getLong("ctCollectionId"), this._ctScoreCalculator.calculate(message.getLong("modelClassNameId")));
        }
    }
}

