/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.messaging;

import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import java.util.Objects;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/ct_entry_reindex"}, service={MessageListener.class})
public class CTEntryReindexMessageListener
extends BaseMessageListener {
    private static final Log _log = LogFactoryUtil.getLog(CTEntryReindexMessageListener.class);
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference(target="(indexer.class.name=com.liferay.change.tracking.model.CTEntry)")
    private Indexer<CTEntry> _indexer;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    private ServiceRegistration<Destination> _serviceRegistration;
    @Reference
    private UIDFactory _uidFactory;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("serial", "liferay/ct_entry_reindex");
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the CTEntry indexer task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, MapUtil.singletonDictionary((Object)"destination.name", (Object)destination.getName()));
    }

    @Deactivate
    protected void deactivate() {
        if (this._serviceRegistration != null) {
            this._serviceRegistration.unregister();
        }
    }

    protected void doReceive(Message message) throws Exception {
        block13: {
            if (this._indexer == null) {
                return;
            }
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                if (Objects.equals(message.getString("type"), "reindex")) {
                    CTEntry ctEntry = this._ctEntryLocalService.fetchCTEntry(message.getLong("ctEntryId"));
                    if (ctEntry == null) {
                        return;
                    }
                    this._indexer.reindex((Object)ctEntry);
                } else {
                    this._indexWriterHelper.deleteDocument(message.getLong("companyId"), this._uidFactory.getUID(this._indexer.getClassName(), (Serializable)Long.valueOf(message.getLong("ctEntryId")), 0L), this._indexer.isCommitImmediately());
                }
            }
            catch (Exception exception) {
                if (!_log.isWarnEnabled()) break block13;
                _log.warn((Throwable)exception);
            }
        }
    }
}

