/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.background.task;

import com.liferay.change.tracking.internal.CTRowUtil;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnectionUtil;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.PropsValues;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class CTServicePublisher<T extends CTModel<T>> {
    private static final int _BATCH_SIZE = 50000;
    private Map<Serializable, CTEntry> _additionCTEntries;
    private final CTEntryLocalService _ctEntryLocalService;
    private final CTService<T> _ctService;
    private Map<Serializable, CTEntry> _deletionCTEntries;
    private final long _modelClassNameId;
    private Map<Serializable, CTEntry> _modificationCTEntries;
    private final long _sourceCTCollectionId;
    private final long _targetCTCollectionId;

    public CTServicePublisher(CTEntryLocalService ctEntryLocalService, CTService<T> ctService, long modelClassNameId, long sourceCTCollectionId, long targetCTCollectionId) {
        this._ctEntryLocalService = ctEntryLocalService;
        this._ctService = ctService;
        this._modelClassNameId = modelClassNameId;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public void addCTEntry(CTEntry ctEntry) {
        long modelClassPK = ctEntry.getModelClassPK();
        int changeType = ctEntry.getChangeType();
        if (changeType == 0) {
            if (this._additionCTEntries == null) {
                this._additionCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._additionCTEntries.put(Long.valueOf(modelClassPK), ctEntry);
        } else if (changeType == 1) {
            if (this._deletionCTEntries == null) {
                this._deletionCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._deletionCTEntries.put(Long.valueOf(modelClassPK), ctEntry);
        } else {
            if (this._modificationCTEntries == null) {
                this._modificationCTEntries = new HashMap<Serializable, CTEntry>();
            }
            this._modificationCTEntries.put(Long.valueOf(modelClassPK), ctEntry);
        }
    }

    public void publish() throws Exception {
        this._ctService.updateWithUnsafeFunction(this::_publish);
    }

    private void _copyCTRow(Connection connection, CTPersistence<?> ctPersistence, String tableName, String primaryKeyName, Serializable primaryKey, long tempCTCollectionId) throws Exception {
        StringBundler sb = new StringBundler();
        Map tableColumnsMap = ctPersistence.getTableColumnsMap();
        sb.append("select ");
        for (String name : tableColumnsMap.keySet()) {
            if (name.equals("ctCollectionId")) {
                sb.append(this._targetCTCollectionId);
                sb.append(" as ");
            } else if (name.equals("mvccVersion")) {
                sb.append("(mvccVersion + 1) ");
            }
            sb.append(name);
            sb.append(", ");
        }
        sb.setStringAt(" from ", sb.index() - 1);
        sb.append(tableName);
        sb.append(" where ");
        sb.append(primaryKeyName);
        sb.append(" = ");
        sb.append((Object)primaryKey);
        sb.append(" and ctCollectionId = ");
        sb.append(tempCTCollectionId);
        CTRowUtil.copyCTRows(ctPersistence, connection, sb.toString());
    }

    private int _getPredeletedRowCount(Connection connection, String tableName, String primaryKeyName) throws Exception {
        try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select count(*) from CTEntry left join ", tableName, " on CTEntry.modelClassPK = ", tableName, ".", primaryKeyName, " and ", tableName, ".ctCollectionId = ? ", "where CTEntry.changeType = ? and CTEntry.ctCollectionId ", "= ? and CTEntry.modelClassNameId = ? and ", tableName, ".", primaryKeyName, " is null"}));){
            preparedStatement.setLong(1, this._targetCTCollectionId);
            preparedStatement.setInt(2, 1);
            preparedStatement.setLong(3, this._sourceCTCollectionId);
            preparedStatement.setLong(4, this._modelClassNameId);
            try (ResultSet resultSet = preparedStatement.executeQuery();){
                if (resultSet.next()) {
                    int n = resultSet.getInt(1);
                    return n;
                }
            }
        }
        return 0;
    }

    private Void _publish(CTPersistence<T> ctPersistence) throws Exception {
        String tableName = ctPersistence.getTableName();
        Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
        if (primaryKeyNames.size() != 1) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", tableName, "}"}));
        }
        Iterator iterator = primaryKeyNames.iterator();
        String primaryKeyName = (String)iterator.next();
        long tempCTCollectionId = -this._sourceCTCollectionId;
        Connection connection = CurrentConnectionUtil.getConnection((DataSource)ctPersistence.getDataSource());
        if (this._additionCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._additionCTEntries.values(), this._sourceCTCollectionId, tempCTCollectionId, false, false);
        }
        if (this._modificationCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._modificationCTEntries.values(), this._sourceCTCollectionId, tempCTCollectionId, false, true);
        }
        if (this._deletionCTEntries != null) {
            int updatedRowCount;
            int predeletedRowCount = this._getPredeletedRowCount(connection, tableName, primaryKeyName);
            if (predeletedRowCount != this._deletionCTEntries.size() && predeletedRowCount + (updatedRowCount = this._updateCTCollectionId(connection, tableName, primaryKeyName, this._deletionCTEntries.values(), this._targetCTCollectionId, this._sourceCTCollectionId, false, false)) != this._deletionCTEntries.size()) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Size mismatch expected ", this._deletionCTEntries.size(), " but was ", updatedRowCount}));
            }
            this._updateModelMvccVersion(connection, tableName, primaryKeyName, this._deletionCTEntries, this._sourceCTCollectionId);
        }
        if (this._modificationCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._modificationCTEntries.values(), this._targetCTCollectionId, this._sourceCTCollectionId, true, true);
        }
        if (this._additionCTEntries != null) {
            this._updateCTCollectionId(connection, tableName, primaryKeyName, this._additionCTEntries.values(), tempCTCollectionId, this._targetCTCollectionId, false, false);
            this._updateModelMvccVersion(connection, tableName, primaryKeyName, this._additionCTEntries, this._targetCTCollectionId);
        }
        if (this._modificationCTEntries != null) {
            for (Serializable primaryKey : this._modificationCTEntries.keySet()) {
                this._copyCTRow(connection, ctPersistence, tableName, primaryKeyName, primaryKey, tempCTCollectionId);
            }
            StringBundler sb = new StringBundler(7);
            sb.append("delete from ");
            sb.append(tableName);
            sb.append(" where ctCollectionId = ");
            sb.append(tempCTCollectionId);
            sb.append(" and ");
            sb.append(primaryKeyName);
            sb.append(" = ?");
            try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)sb.toString());){
                for (Serializable primaryKey : this._modificationCTEntries.keySet()) {
                    preparedStatement.setLong(1, (Long)primaryKey);
                    preparedStatement.addBatch();
                }
                preparedStatement.executeBatch();
            }
            this._updateModelMvccVersion(connection, tableName, primaryKeyName, this._modificationCTEntries, this._targetCTCollectionId);
        }
        if (this._additionCTEntries != null) {
            ctPersistence.clearCache(this._additionCTEntries.keySet());
        }
        if (this._deletionCTEntries != null) {
            ctPersistence.clearCache(this._deletionCTEntries.keySet());
        }
        if (this._modificationCTEntries != null) {
            ctPersistence.clearCache(this._modificationCTEntries.keySet());
        }
        return null;
    }

    private int _updateCTCollectionId(Connection connection, String tableName, String primaryKeyName, Collection<CTEntry> ctEntries, long fromCTCollectionId, long toCTCollectionId, boolean includeMvccVersion, boolean checkRowCount) throws Exception {
        StringBundler sb = new StringBundler(16);
        sb.append("update ");
        sb.append(tableName);
        sb.append(" set ctCollectionId = ");
        sb.append(toCTCollectionId);
        sb.append(" where ");
        sb.append(tableName);
        sb.append(".ctCollectionId = ");
        sb.append(fromCTCollectionId);
        sb.append(" and ");
        sb.append(tableName);
        sb.append(".");
        sb.append(primaryKeyName);
        sb.append(" = ?");
        if (includeMvccVersion) {
            sb.append(" and ");
            sb.append(tableName);
            sb.append(".mvccVersion = ?");
        }
        try (PreparedStatement preparedStatement = connection.prepareStatement(sb.toString());){
            int batchCount = 0;
            int totalRowCount = 0;
            for (CTEntry ctEntry : ctEntries) {
                preparedStatement.setLong(1, ctEntry.getModelClassPK());
                if (includeMvccVersion) {
                    preparedStatement.setLong(2, ctEntry.getModelMvccVersion());
                }
                preparedStatement.addBatch();
                if (++batchCount < PropsValues.HIBERNATE_JDBC_BATCH_SIZE) continue;
                batchCount = 0;
                for (int rowCount : preparedStatement.executeBatch()) {
                    totalRowCount += rowCount;
                }
            }
            for (Object rowCount : (Object)preparedStatement.executeBatch()) {
                totalRowCount += rowCount;
            }
            if (checkRowCount && totalRowCount != ctEntries.size()) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Size mismatch expected ", ctEntries.size(), " but was ", totalRowCount}));
            }
            int n = totalRowCount;
            return n;
        }
    }

    private void _updateModelMvccVersion(Connection connection, String tableName, String primaryKeyName, Map<Serializable, CTEntry> ctEntries, long ctCollectionId) throws Exception {
        int count = 0;
        ArrayList<Serializable> primaryKeys = new ArrayList<Serializable>(ctEntries.keySet());
        while (count < primaryKeys.size()) {
            int batchCount = count;
            if ((count += 50000) > primaryKeys.size()) {
                count = primaryKeys.size();
            }
            PreparedStatement preparedStatement = connection.prepareStatement(CTRowUtil.getUpdateMVCCVersionSQL(ctCollectionId, ListUtil.subList(primaryKeys, (int)batchCount, (int)count), primaryKeyName, tableName));
            try {
                ResultSet resultSet = preparedStatement.executeQuery();
                try {
                    while (resultSet.next()) {
                        long primaryKey = resultSet.getLong(1);
                        long mvccVersion = resultSet.getLong(2);
                        CTEntry ctEntry = ctEntries.get(primaryKey);
                        this._ctEntryLocalService.updateModelMvccVersion(ctEntry.getCtEntryId(), mvccVersion);
                    }
                }
                finally {
                    if (resultSet == null) continue;
                    resultSet.close();
                }
            }
            finally {
                if (preparedStatement == null) continue;
                preparedStatement.close();
            }
        }
    }
}

