/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.internal.helper.CTUserNotificationHelper;
import com.liferay.change.tracking.internal.score.CTScoreCalculator;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTScore;
import com.liferay.change.tracking.model.impl.CTScoreImpl;
import com.liferay.change.tracking.service.base.CTScoreLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.change.tracking.service.persistence.CTEntryPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.SQLStateAcceptor;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@CTAware(onProduction=true)
@Component(property={"model.class.name=com.liferay.change.tracking.model.CTScore"}, service={AopService.class})
public class CTScoreLocalServiceImpl
extends CTScoreLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(CTScoreLocalServiceImpl.class);
    @Reference
    private CTCollectionPersistence _ctCollectionPersistence;
    @Reference
    private CTEntryPersistence _ctEntryPersistence;
    @Reference
    private CTScoreCalculator _ctScoreCalculator;
    @Reference
    private CTUserNotificationHelper _ctUserNotificationHelper;
    @Reference
    private EntityCache _entityCache;

    public CTScore addCTScore(long ctCollectionId) {
        return this._updateScore(ctCollectionId, 0);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23,40")})
    public CTScore decrementScore(long ctCollectionId, int score) {
        return this._updateScore(ctCollectionId, -1 * score);
    }

    public CTScore fetchCTScoreByCTCollectionId(long ctCollectionId) {
        return this.ctScorePersistence.fetchByCtCollectionId(ctCollectionId);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23,40")})
    public CTScore incrementScore(long ctCollectionId, int score) {
        return this._updateScore(ctCollectionId, score);
    }

    private void _sendUserNotificationEvents(CTScore ctScore, CTScore originalCTScore) {
        String sizeClassification;
        if (ctScore == null || originalCTScore == null) {
            return;
        }
        String originalSizeClassification = originalCTScore.getSizeClassification();
        if (Objects.equals(originalSizeClassification, sizeClassification = ctScore.getSizeClassification())) {
            return;
        }
        long ctCollectionId = ctScore.getCtCollectionId();
        try {
            CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
            Set userIds = SetUtil.fromArray((long[])this._ctUserNotificationHelper.getPublicationRoleUserIds(ctCollection, true, "com_liferay_change_tracking_web_portlet_PublicationsPortlet.admin", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.publisher"));
            this._ctUserNotificationHelper.sendUserNotificationEvents(ctCollection, JSONUtil.put((String)"ctCollectionId", (Object)ctCollectionId).put("notificationType", 1).put("originalSizeClassification", originalSizeClassification).put("sizeClassification", sizeClassification), ArrayUtil.toLongArray((Collection)userIds));
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to send user notification events", (Throwable)portalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTScore _updateScore(long ctCollectionId, int score) {
        CTCollection ctCollection = this._ctCollectionPersistence.fetchByPrimaryKey(ctCollectionId);
        if (ctCollection == null) {
            return null;
        }
        CTScore originalCTScore = this.ctScorePersistence.fetchByCtCollectionId(ctCollectionId);
        long ctScoreId = 0L;
        if (originalCTScore != null) {
            if (originalCTScore.getScore() == 0 && score <= 0) {
                return originalCTScore;
            }
            ctScoreId = originalCTScore.getCtScoreId();
        } else {
            ctScoreId = this.counterLocalService.increment(CTScore.class.getName());
        }
        Session session = this.ctScorePersistence.openSession();
        CTScore ctScore = null;
        try {
            ctScore = (CTScore)session.get(CTScoreImpl.class, (Serializable)Long.valueOf(ctScoreId), LockMode.UPGRADE);
            if (ctScore == null) {
                ctScore = new CTScoreImpl();
                ctScore.setCtScoreId(ctScoreId);
                ctScore.setCompanyId(ctCollection.getCompanyId());
                ctScore.setCtCollectionId(ctCollectionId);
                List ctEntries = this._ctEntryPersistence.findByCtCollectionId(ctCollectionId);
                for (CTEntry ctEntry : ctEntries) {
                    score += this._ctScoreCalculator.calculate(ctEntry.getModelClassNameId());
                }
                ctScore.setScore(score);
                session.save((Object)ctScore);
                session.flush();
            } else {
                score = ctScore.getScore() + score;
                if (score < 0) {
                    score = 0;
                }
                ctScore.setScore(score);
                session.saveOrUpdate((Object)ctScore);
            }
            this._entityCache.putResult(CTScoreImpl.class, (BaseModel)ctScore, false, true);
        }
        finally {
            this.ctScorePersistence.closeSession(session);
        }
        this._sendUserNotificationEvents(ctScore, originalCTScore);
        return ctScore;
    }
}

