/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.closure.CTClosureFactory;
import com.liferay.change.tracking.configuration.CTSettingsConfiguration;
import com.liferay.change.tracking.conflict.CTEntryConflictHelper;
import com.liferay.change.tracking.conflict.ConflictInfo;
import com.liferay.change.tracking.exception.CTCollectionDescriptionException;
import com.liferay.change.tracking.exception.CTCollectionNameException;
import com.liferay.change.tracking.exception.CTCollectionStatusException;
import com.liferay.change.tracking.exception.CTEnclosureException;
import com.liferay.change.tracking.exception.CTLocalizedException;
import com.liferay.change.tracking.exception.CTPublishConflictException;
import com.liferay.change.tracking.internal.CTEnclosureUtil;
import com.liferay.change.tracking.internal.CTServiceCopier;
import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.conflict.CTConflictChecker;
import com.liferay.change.tracking.internal.conflict.ConstraintResolverConflictInfo;
import com.liferay.change.tracking.internal.conflict.ModificationConflictInfo;
import com.liferay.change.tracking.internal.helper.CTTableMapperHelper;
import com.liferay.change.tracking.internal.reference.TableReferenceDefinitionManager;
import com.liferay.change.tracking.internal.resolver.ConstraintResolverKey;
import com.liferay.change.tracking.mapping.CTMappingTableInfo;
import com.liferay.change.tracking.model.CTAutoResolutionInfo;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTEntryModel;
import com.liferay.change.tracking.model.CTEntryTable;
import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.model.CTSchemaVersion;
import com.liferay.change.tracking.model.CTScore;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.CTPreferencesLocalService;
import com.liferay.change.tracking.service.CTSchemaVersionLocalService;
import com.liferay.change.tracking.service.base.CTCollectionLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTAutoResolutionInfoPersistence;
import com.liferay.change.tracking.service.persistence.CTCommentPersistence;
import com.liferay.change.tracking.service.persistence.CTEntryPersistence;
import com.liferay.change.tracking.service.persistence.CTMessagePersistence;
import com.liferay.change.tracking.service.persistence.CTPreferencesPersistence;
import com.liferay.change.tracking.service.persistence.CTScorePersistence;
import com.liferay.change.tracking.spi.display.CTDisplayRenderer;
import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.sort.OrderByExpression;
import com.liferay.petra.string.StringBundler;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.jdbc.AutoBatchPreparedStatementUtil;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.ClassName;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.GroupedModel;
import com.liferay.portal.kernel.model.ModelHintsUtil;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.search.IndexWriterHelper;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistry;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.ResourcePermissionLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.WorkflowDefinitionLinkLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.model.uid.UIDFactory;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.change.tracking.configuration.CTSettingsConfiguration"}, property={"model.class.name=com.liferay.change.tracking.model.CTCollection"}, service={AopService.class})
public class CTCollectionLocalServiceImpl
extends CTCollectionLocalServiceBaseImpl {
    private static final int _BATCH_SIZE = 1000;
    private static final Log _log = LogFactoryUtil.getLog(CTCollectionLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private ConfigurationProvider _configurationProvider;
    private ServiceTrackerMap<ConstraintResolverKey, ConstraintResolver<?>> _constraintResolverServiceTrackerMap;
    @Reference
    private CTAutoResolutionInfoPersistence _ctAutoResolutionInfoPersistence;
    @Reference
    private CTClosureFactory _ctClosureFactory;
    @Reference
    private CTCommentPersistence _ctCommentPersistence;
    private ServiceTrackerMap<String, CTDisplayRenderer<?>> _ctDisplayRendererServiceTrackerMap;
    private ServiceTrackerMap<String, CTEntryConflictHelper> _ctEntryConflictHelperServiceTrackerMap;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTEntryPersistence _ctEntryPersistence;
    @Reference
    private CTMessagePersistence _ctMessagePersistence;
    @Reference
    private CTPreferencesLocalService _ctPreferencesLocalService;
    @Reference
    private CTPreferencesPersistence _ctPreferencesPersistence;
    @Reference
    private CTSchemaVersionLocalService _ctSchemaVersionLocalService;
    @Reference
    private CTScorePersistence _ctScorePersistence;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private IndexerRegistry _indexerRegistry;
    @Reference
    private IndexWriterHelper _indexWriterHelper;
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private ResourcePermissionLocalService _resourcePermissionLocalService;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private TableReferenceDefinitionManager _tableReferenceDefinitionManager;
    @Reference
    private UIDFactory _uidFactory;
    @Reference
    private WorkflowDefinitionLinkLocalService _workflowDefinitionLinkLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CTCollection addCTCollection(String externalReferenceCode, long companyId, long userId, long ctRemoteId, String name, String description) throws PortalException {
        this._validate(name, description);
        long ctCollectionId = this.counterLocalService.increment(CTCollection.class.getName());
        CTCollection ctCollection = this.ctCollectionPersistence.create(ctCollectionId);
        ctCollection.setExternalReferenceCode(externalReferenceCode);
        ctCollection.setCompanyId(companyId);
        ctCollection.setUserId(userId);
        ctCollection.setCtRemoteId(ctRemoteId);
        CTSchemaVersion latestCTSchemaVersion = this._ctSchemaVersionLocalService.getLatestCTSchemaVersion(companyId);
        ctCollection.setSchemaVersionId(latestCTSchemaVersion.getSchemaVersionId());
        ctCollection.setName(name);
        ctCollection.setDescription(description);
        ctCollection.setShareable(false);
        ctCollection.setStatus(2);
        ctCollection = (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
        CTScore ctScore = this._ctScorePersistence.create(this.counterLocalService.increment(CTScore.class.getName()));
        ctScore.setCompanyId(companyId);
        ctScore.setCtCollectionId(ctCollectionId);
        this._ctScorePersistence.update((BaseModel)ctScore);
        this._resourceLocalService.addResources(ctCollection.getCompanyId(), 0L, ctCollection.getUserId(), CTCollection.class.getName(), ctCollection.getCtCollectionId(), false, false, false);
        CTSettingsConfiguration ctSettingsConfiguration = (CTSettingsConfiguration)this._configurationProvider.getCompanyConfiguration(CTSettingsConfiguration.class, ctCollection.getCompanyId());
        if (ArrayUtil.isNotEmpty((Object[])ctSettingsConfiguration.defaultOwnerActionIds())) {
            Role role = this._roleLocalService.getRole(ctCollection.getCompanyId(), "Owner");
            this._resourcePermissionLocalService.setResourcePermissions(ctCollection.getCompanyId(), CTCollection.class.getName(), 4, String.valueOf(ctCollection.getCtCollectionId()), role.getRoleId(), ctSettingsConfiguration.defaultOwnerActionIds());
        }
        return ctCollection;
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(CTCollection ctCollection) throws PortalException {
        List ctEntries = this._ctEntryPersistence.findByCtCollectionId(ctCollection.getCtCollectionId());
        return this.checkConflicts(ctCollection.getCompanyId(), ctEntries, ctCollection.getCtCollectionId(), ctCollection.getName(), 0L, "Production");
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(long companyId, List<CTEntry> ctEntries, long fromCTCollectionId, String fromCTCollectionName, long toCTCollectionId, String toCTCollectionName) throws PortalException {
        HashMap<Long, List<ConflictInfo>> conflictInfosMap = new HashMap<Long, List<ConflictInfo>>();
        HashMap<Long, CTConflictChecker> ctConflictCheckers = new HashMap<Long, CTConflictChecker>();
        CTSettingsConfiguration ctSettingsConfiguration = (CTSettingsConfiguration)this._configurationProvider.getCompanyConfiguration(CTSettingsConfiguration.class, companyId);
        for (CTEntry ctEntry : ctEntries) {
            CTConflictChecker ctConflictChecker = ctConflictCheckers.computeIfAbsent(ctEntry.getModelClassNameId(), modelClassNameId -> {
                CTService<?> ctService = this._ctServiceRegistry.getCTService((long)modelClassNameId);
                if (ctService == null) {
                    throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to check conflicts for ", fromCTCollectionName, " to ", toCTCollectionName, " because service for ", modelClassNameId, " is missing"}));
                }
                return new CTConflictChecker(this._classNameLocalService, this._constraintResolverServiceTrackerMap, this._ctDisplayRendererServiceTrackerMap, this._ctEntryConflictHelperServiceTrackerMap, this._ctEntryLocalService, ctService, ctSettingsConfiguration, (long)modelClassNameId, fromCTCollectionId, this._tableReferenceDefinitionManager, toCTCollectionId);
            });
            ctConflictChecker.addCTEntry(ctEntry);
        }
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)fromCTCollectionId);){
            for (Map.Entry entry : ctConflictCheckers.entrySet()) {
                CTConflictChecker ctConflictChecker = (CTConflictChecker)entry.getValue();
                List<ConflictInfo> conflictInfos = ctConflictChecker.check();
                if (conflictInfos.isEmpty()) continue;
                conflictInfosMap.put((Long)entry.getKey(), conflictInfos);
            }
        }
        if (toCTCollectionId != 0L) {
            return conflictInfosMap;
        }
        List ctAutoResolutionInfos = this._ctAutoResolutionInfoPersistence.findByCtCollectionId(fromCTCollectionId);
        for (Map.Entry entry : conflictInfosMap.entrySet()) {
            for (ConflictInfo conflictInfo : (List)entry.getValue()) {
                if (!conflictInfo.isResolved()) continue;
                CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.create(this.counterLocalService.increment(CTAutoResolutionInfo.class.getName()));
                ctAutoResolutionInfo.setCompanyId(companyId);
                ctAutoResolutionInfo.setCreateDate(new Date());
                ctAutoResolutionInfo.setCtCollectionId(fromCTCollectionId);
                ctAutoResolutionInfo.setModelClassNameId(((Long)entry.getKey()).longValue());
                ctAutoResolutionInfo.setSourceModelClassPK(conflictInfo.getSourcePrimaryKey());
                ctAutoResolutionInfo.setTargetModelClassPK(conflictInfo.getTargetPrimaryKey());
                if (conflictInfo instanceof ConstraintResolverConflictInfo) {
                    ConstraintResolverConflictInfo constraintResolverConflictInfo = (ConstraintResolverConflictInfo)conflictInfo;
                    ConstraintResolver<?> constraintResolver = constraintResolverConflictInfo.getConstraintResolver();
                    ctAutoResolutionInfo.setConflictIdentifier(StringUtil.merge((String[])constraintResolver.getUniqueIndexColumnNames(), (String)","));
                    constraintResolverConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                } else if (conflictInfo instanceof ModificationConflictInfo) {
                    ModificationConflictInfo resolvedModificationConflictInfo = (ModificationConflictInfo)conflictInfo;
                    resolvedModificationConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                    ctAutoResolutionInfo.setConflictIdentifier(ModificationConflictInfo.class.getName());
                }
                this._ctAutoResolutionInfoPersistence.update((BaseModel)ctAutoResolutionInfo);
            }
        }
        for (CTAutoResolutionInfo ctAutoResolutionInfo : ctAutoResolutionInfos) {
            List conflictInfos = conflictInfosMap.computeIfAbsent(ctAutoResolutionInfo.getModelClassNameId(), key -> new ArrayList());
            if (Objects.equals(ctAutoResolutionInfo.getConflictIdentifier(), ModificationConflictInfo.class.getName())) {
                ModificationConflictInfo resolvedModificationConflictInfo = new ModificationConflictInfo(ctAutoResolutionInfo.getSourceModelClassPK(), true);
                resolvedModificationConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
                conflictInfos.add(resolvedModificationConflictInfo);
                continue;
            }
            List uniqueIndexes = StringUtil.split((String)ctAutoResolutionInfo.getConflictIdentifier(), (char)',');
            ClassName className = this._classNameLocalService.getClassName(ctAutoResolutionInfo.getModelClassNameId());
            ConstraintResolver constraintResolver = (ConstraintResolver)this._constraintResolverServiceTrackerMap.getService((Object)new ConstraintResolverKey(className.getValue(), uniqueIndexes.toArray(new String[0])));
            if (constraintResolver == null) continue;
            ConstraintResolverConflictInfo constraintResolverConflictInfo = new ConstraintResolverConflictInfo(constraintResolver, true, ctAutoResolutionInfo.getSourceModelClassPK(), ctAutoResolutionInfo.getTargetModelClassPK());
            constraintResolverConflictInfo.setCtAutoResolutionInfoId(ctAutoResolutionInfo.getCtAutoResolutionInfoId());
            conflictInfos.add(constraintResolverConflictInfo);
        }
        return conflictInfosMap;
    }

    public Map<Long, List<ConflictInfo>> checkConflicts(long companyId, long[] ctEntryIds, long fromCTCollectionId, String fromCTCollectionName, long toCTCollectionId, String toCTCollectionName) throws PortalException {
        List<CTEntry> ctEntries = this.getRelatedCTEntries(fromCTCollectionId, ctEntryIds);
        return this.checkConflicts(companyId, ctEntries, fromCTCollectionId, fromCTCollectionName, toCTCollectionId, toCTCollectionName);
    }

    public void deleteCompanyCTCollections(long companyId) throws PortalException {
        List ctCollections = this.ctCollectionPersistence.findByCompanyId(companyId);
        for (CTCollection ctCollection : ctCollections) {
            this.deleteCTCollection(ctCollection);
        }
    }

    public void deleteCTAutoResolutionInfo(long ctAutoResolutionInfoId) {
        CTAutoResolutionInfo ctAutoResolutionInfo = this._ctAutoResolutionInfoPersistence.fetchByPrimaryKey(ctAutoResolutionInfoId);
        if (ctAutoResolutionInfo != null) {
            this._ctAutoResolutionInfoPersistence.remove((BaseModel)ctAutoResolutionInfo);
        }
    }

    @Override
    @Indexable(type=IndexableType.DELETE)
    public CTCollection deleteCTCollection(CTCollection ctCollection) throws PortalException {
        Indexer indexer;
        CTSchemaVersion ctSchemaVersion;
        Group group;
        this._ctServiceRegistry.onBeforeRemove(ctCollection.getCtCollectionId());
        try {
            for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
                ctTableMapperHelper.delete(ctCollection.getCtCollectionId());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        List ctEntries = this._ctEntryPersistence.findByCtCollectionId(ctCollection.getCtCollectionId());
        HashMap<Long, ArrayList<Long>> modelClassPKsMap = new HashMap<Long, ArrayList<Long>>();
        for (CTEntry cTEntry : ctEntries) {
            ArrayList<Long> modelClassPKs = (ArrayList<Long>)modelClassPKsMap.get(cTEntry.getModelClassNameId());
            if (modelClassPKs == null) {
                modelClassPKs = new ArrayList<Long>();
                modelClassPKsMap.put(cTEntry.getModelClassNameId(), modelClassPKs);
            }
            modelClassPKs.add(cTEntry.getModelClassPK());
        }
        for (Map.Entry entry : modelClassPKsMap.entrySet()) {
            CTService<?> ctService = this._ctServiceRegistry.getCTService((Long)entry.getKey());
            if (ctService == null) {
                if (!_log.isWarnEnabled()) continue;
                _log.warn((Object)("No CT service found for class name ID " + String.valueOf(entry.getKey())));
                continue;
            }
            ctService.updateWithUnsafeFunction(ctPersistence -> {
                Object object;
                block10: {
                    Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
                    if (primaryKeyNames.size() != 1) {
                        throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
                    }
                    Iterator iterator = primaryKeyNames.iterator();
                    String primaryKeyName = (String)iterator.next();
                    StringBundler sb = new StringBundler(7);
                    sb.append("delete from ");
                    sb.append(ctPersistence.getTableName());
                    sb.append(" where ctCollectionId = ");
                    sb.append(ctCollection.getCtCollectionId());
                    sb.append(" and ");
                    sb.append(primaryKeyName);
                    sb.append(" = ?");
                    Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
                    PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)sb.toString());
                    try {
                        object = ((List)entry.getValue()).iterator();
                        while (object.hasNext()) {
                            long modelClassPK = (Long)object.next();
                            preparedStatement.setLong(1, modelClassPK);
                            preparedStatement.addBatch();
                        }
                        object = preparedStatement.executeBatch();
                        if (preparedStatement == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (preparedStatement != null) {
                                try {
                                    preparedStatement.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception exception) {
                            throw new SystemException((Throwable)exception);
                        }
                    }
                    preparedStatement.close();
                }
                return object;
            });
        }
        this._ctAutoResolutionInfoPersistence.removeByCtCollectionId(ctCollection.getCtCollectionId());
        this._ctCommentPersistence.removeByCtCollectionId(ctCollection.getCtCollectionId());
        for (CTEntry cTEntry : ctEntries) {
            this._ctEntryPersistence.remove((BaseModel)cTEntry);
        }
        this._ctMessagePersistence.removeByCtCollectionId(ctCollection.getCtCollectionId());
        CTScore ctScore = this._ctScorePersistence.fetchByCtCollectionId(ctCollection.getCtCollectionId());
        if (ctScore != null) {
            this._ctScorePersistence.remove((BaseModel)ctScore);
        }
        if ((group = this._groupLocalService.fetchGroup(ctCollection.getCompanyId(), this._classNameLocalService.getClassNameId(CTCollection.class), ctCollection.getCtCollectionId())) != null) {
            this._groupLocalService.deleteGroup(group);
        }
        this._resourceLocalService.deleteResource(ctCollection.getCompanyId(), CTCollection.class.getName(), 4, ctCollection.getCtCollectionId());
        int count = this.ctCollectionPersistence.countByC_SVI(ctCollection.getCompanyId(), ctCollection.getSchemaVersionId());
        if (count == 1 && (ctSchemaVersion = this._ctSchemaVersionLocalService.fetchCTSchemaVersion(ctCollection.getSchemaVersionId())) != null && !this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(ctSchemaVersion, true)) {
            this._ctSchemaVersionLocalService.deleteCTSchemaVersion(ctSchemaVersion);
        }
        if ((indexer = this._indexerRegistry.getIndexer(CTEntry.class)) != null) {
            this._indexWriterHelper.deleteDocuments(ctCollection.getCompanyId(), (Collection)TransformUtil.transform((Collection)ctEntries, ctEntry -> this._uidFactory.getUID((ClassedModel)ctEntry)), indexer.isCommitImmediately());
        }
        return (CTCollection)this.ctCollectionPersistence.remove((BaseModel)ctCollection);
    }

    public void discardCTEntry(long ctCollectionId, List<CTEntry> ctEntries, boolean force) throws PortalException {
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (!force && ctCollection.isReadOnly()) {
            throw new PortalException("Change tracking collection " + String.valueOf(ctCollection) + " is read only");
        }
        Map<Long, List<CTEntry>> relateCTEntriesMap = this.getRelatedCTEntriesMap(ctCollection.getCtCollectionId(), ctEntries);
        for (Map.Entry<Long, List<CTEntry>> entry : relateCTEntriesMap.entrySet()) {
            this._discardCTEntries(ctCollection, entry.getKey(), entry.getValue(), force);
        }
        this._ctClosureFactory.clearCache(ctCollection.getCtCollectionId());
    }

    public void discardCTEntry(long ctCollectionId, long modelClassNameId, long modelClassPK, boolean force) throws PortalException {
        CTEntry ctEntry = this._ctEntryPersistence.findByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
        this.discardCTEntry(ctCollectionId, Collections.singletonList(ctEntry), force);
    }

    public List<CTCollection> getCTCollections(long companyId, int status, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (status == -1) {
            return this.ctCollectionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.ctCollectionPersistence.findByC_S(companyId, status, start, end, orderByComparator);
    }

    public List<CTCollection> getCTCollections(long companyId, int[] statuses, int start, int end, OrderByComparator<CTCollection> orderByComparator) {
        if (ArrayUtil.contains((int[])statuses, (int)-1)) {
            return this.ctCollectionPersistence.findByCompanyId(companyId, start, end, orderByComparator);
        }
        return this.ctCollectionPersistence.findByC_S(companyId, statuses, start, end, orderByComparator);
    }

    public List<CTMappingTableInfo> getCTMappingTableInfos(long ctCollectionId) {
        ArrayList<CTMappingTableInfo> ctMappingTableInfos = new ArrayList<CTMappingTableInfo>();
        for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
            CTMappingTableInfo ctMappingTableInfo = ctTableMapperHelper.getCTMappingTableInfo(ctCollectionId);
            if (ctMappingTableInfo == null) continue;
            ctMappingTableInfos.add(ctMappingTableInfo);
        }
        return ctMappingTableInfos;
    }

    public List<CTCollection> getExclusivePublishedCTCollections(long modelClassNameId, long modelClassPK) throws PortalException {
        return (List)this.ctCollectionPersistence.dslQuery((DSLQuery)DSLQueryFactoryUtil.select((Table)CTCollectionTable.INSTANCE).from((Table)CTCollectionTable.INSTANCE).innerJoinON((Table)CTEntryTable.INSTANCE, CTEntryTable.INSTANCE.ctCollectionId.eq((Expression)CTCollectionTable.INSTANCE.ctCollectionId).and((Expression)CTEntryTable.INSTANCE.modelClassNameId.eq((Object)modelClassNameId).and((Expression)CTEntryTable.INSTANCE.modelClassPK.eq((Object)modelClassPK)))).where(CTCollectionTable.INSTANCE.ctCollectionId.neq((Object)CTCollectionThreadLocal.getCTCollectionId()).and((Expression)CTCollectionTable.INSTANCE.status.neq((Object)3))).orderBy(new OrderByExpression[]{CTCollectionTable.INSTANCE.status.descending(), CTCollectionTable.INSTANCE.statusDate.descending()}));
    }

    public List<CTEntry> getRelatedCTEntries(long ctCollectionId, long[] ctEntryIds) throws PortalException {
        HashSet<CTEntry> relatedCTEntries = new HashSet<CTEntry>();
        Map<Long, List<CTEntry>> relatedCTEntriesMap = this.getRelatedCTEntriesMap(ctCollectionId, this._ctEntryLocalService.getCTEntries(ctEntryIds));
        for (List<CTEntry> ctEntries : relatedCTEntriesMap.values()) {
            relatedCTEntries.addAll(ctEntries);
        }
        return new ArrayList<CTEntry>(relatedCTEntries);
    }

    public Map<Long, List<CTEntry>> getRelatedCTEntriesMap(long ctCollectionId, List<CTEntry> ctEntries) throws PortalException {
        HashMap<Long, List<CTEntry>> relatedCTEntriesMap = new HashMap<Long, List<CTEntry>>();
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        for (CTEntry ctEntry : ctEntries) {
            Map<Long, List<CTEntry>> currentRelatedCTEntriesMap = this._getRelatedCTEntriesMap(ctCollection, ctEntry.getModelClassNameId(), ctEntry.getModelClassPK());
            currentRelatedCTEntriesMap.forEach((key, value) -> relatedCTEntriesMap.merge((Long)key, (List<CTEntry>)value, (value1, value2) -> ListUtil.concat((List[])new List[]{value1, value2})));
        }
        for (CTEntry ctEntry : ctEntries) {
            List peerCTEntries = this._ctEntryLocalService.getCTEntries(ctCollectionId, ctEntry.getModelClassNameId());
            for (CTEntry peerCTEntry : peerCTEntries) {
                List relatedCTEntries = (List)relatedCTEntriesMap.get(peerCTEntry.getModelClassNameId());
                if (relatedCTEntries != null && relatedCTEntries.contains(peerCTEntry)) continue;
                Map<Long, List<CTEntry>> peerRelatedCTEntriesMap = this._getRelatedCTEntriesMap(ctCollection, peerCTEntry.getModelClassNameId(), peerCTEntry.getModelClassPK());
                peerRelatedCTEntriesMap.forEach((key1, peerRelatedCTEntries) -> relatedCTEntriesMap.computeIfPresent((Long)key1, (key2, currentCTEntries) -> ListUtil.remove((List)currentCTEntries, (List)peerRelatedCTEntries)));
            }
        }
        return relatedCTEntriesMap;
    }

    public Map<Long, List<CTEntry>> getRelatedCTEntriesMap(long ctCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        CTEntry ctEntry = this._ctEntryPersistence.findByC_MCNI_MCPK(ctCollectionId, modelClassNameId, modelClassPK);
        return this.getRelatedCTEntriesMap(ctCollectionId, Collections.singletonList(ctEntry));
    }

    public Map<Long, List<CTEntry>> getRelatedCTEntriesMap(long ctCollectionId, long[] ctEntryIds) throws PortalException {
        return this.getRelatedCTEntriesMap(ctCollectionId, this._ctEntryLocalService.getCTEntries(ctEntryIds));
    }

    public boolean hasUnapprovedChanges(long ctCollectionId) throws SQLException {
        HashMap<Long, CTPersistence> ctPersistences = new HashMap<Long, CTPersistence>();
        HashSet<Long> modelClassNameIds = new HashSet<Long>();
        for (CTEntry cTEntry : this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId)) {
            long modelClassNameId = cTEntry.getModelClassNameId();
            if (ctPersistences.containsKey(modelClassNameId) || modelClassNameIds.contains(modelClassNameId)) continue;
            CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
            if (ctService == null) {
                throw new SystemException(StringBundler.concat((Object[])new Object[]{"Unable to check for unapproved changes for change ", "tracking collection ", ctCollectionId, " because the service for ", modelClassNameId, " is missing"}));
            }
            CTPersistence ctPersistence = ctService.getCTPersistence();
            Map tableColumnsMap = ctPersistence.getTableColumnsMap();
            if (tableColumnsMap.containsKey("status") && tableColumnsMap.containsKey("statusByUserId")) {
                ctPersistences.putIfAbsent(modelClassNameId, ctService.getCTPersistence());
                continue;
            }
            modelClassNameIds.add(modelClassNameId);
        }
        for (Map.Entry entry : ctPersistences.entrySet()) {
            CTPersistence ctPersistence = (CTPersistence)entry.getValue();
            DataSource dataSource = ctPersistence.getDataSource();
            Connection connection = dataSource.getConnection();
            try {
                PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((Object[])new Object[]{"select count(*) from ", ctPersistence.getTableName(), " where ctCollectionId = ", ctCollectionId, " and status not in (", StringUtil.merge((int[])this._getStatuses(ctCollectionId, ctPersistence, entry), (String)","), ")"}));
                try {
                    ResultSet resultSet = preparedStatement.executeQuery();
                    try {
                        int count;
                        if (!resultSet.next() || (count = resultSet.getInt(1)) <= 0) continue;
                        boolean bl = true;
                        return bl;
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            finally {
                if (connection == null) continue;
                connection.close();
            }
        }
        return false;
    }

    public boolean isCTEntryEnclosed(long ctCollectionId, long modelClassNameId, long modelClassPK) {
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollectionId);
        Map<Long, Set<Long>> enclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, modelClassNameId, modelClassPK);
        for (Map.Entry<Long, Long> entry : CTEnclosureUtil.getEnclosureParentEntries(ctClosure, enclosureMap)) {
            int count = this._ctEntryPersistence.countByC_MCNI_MCPK(ctCollectionId, entry.getKey().longValue(), entry.getValue().longValue());
            if (count <= 0) continue;
            return false;
        }
        return true;
    }

    public void moveCTEntries(long fromCTCollectionId, long toCTCollectionId, List<CTEntry> ctEntries) throws PortalException {
        CTCollection fromCTCollection = this.ctCollectionPersistence.findByPrimaryKey(fromCTCollectionId);
        if (fromCTCollection.getStatus() != 2 && fromCTCollection.getStatus() != 3 && fromCTCollection.getStatus() != 1) {
            throw new CTCollectionStatusException("Change tracking collection " + String.valueOf(fromCTCollection) + " is read only");
        }
        CTCollection toCTCollection = this.ctCollectionPersistence.findByPrimaryKey(toCTCollectionId);
        if (toCTCollection.isReadOnly()) {
            throw new CTCollectionStatusException("Change tracking collection " + String.valueOf(toCTCollection) + " is read only");
        }
        Map<Long, List<CTEntry>> relatedCTEntriesMap = this.getRelatedCTEntriesMap(fromCTCollection.getCtCollectionId(), ctEntries);
        ArrayList<CTEntry> relatedCTEntries = new ArrayList<CTEntry>();
        for (List<CTEntry> value : relatedCTEntriesMap.values()) {
            relatedCTEntries.addAll(value);
        }
        Map<Long, List<ConflictInfo>> conflictInfosMap = this.checkConflicts(fromCTCollection.getCompanyId(), relatedCTEntries, fromCTCollectionId, fromCTCollection.getName(), toCTCollectionId, toCTCollection.getName());
        if (!conflictInfosMap.isEmpty()) {
            throw new CTPublishConflictException("Conflict detected");
        }
        for (Map.Entry<Long, List<CTEntry>> entry : relatedCTEntriesMap.entrySet()) {
            this._moveCTEntries(fromCTCollection.getCompanyId(), fromCTCollectionId, toCTCollectionId, entry.getKey(), entry.getValue());
        }
        conflictInfosMap = this.checkConflicts(toCTCollection.getCompanyId(), this.getRelatedCTEntries(toCTCollection.getCtCollectionId(), TransformUtil.transformToLongArray(ctEntries, CTEntryModel::getCtEntryId)), toCTCollectionId, toCTCollection.getName(), 0L, "Production");
        for (Map.Entry<Long, List<CTEntry>> entry : conflictInfosMap.entrySet()) {
            List<CTEntry> conflictInfos = entry.getValue();
            for (ConflictInfo conflictInfo : conflictInfos) {
                if (conflictInfo.isResolved()) continue;
                throw new CTPublishConflictException("Conflict detected");
            }
        }
        this._ctClosureFactory.clearCache(fromCTCollectionId);
        this._ctClosureFactory.clearCache(toCTCollectionId);
    }

    public void moveCTEntry(long fromCTCollectionId, long toCTCollectionId, long modelClassNameId, long modelClassPK) throws PortalException {
        this.moveCTEntries(fromCTCollectionId, toCTCollectionId, Collections.singletonList(this._ctEntryLocalService.fetchCTEntry(fromCTCollectionId, modelClassNameId, modelClassPK)));
    }

    public CTCollection undoCTCollection(long ctCollectionId, long userId, String name, String description) throws PortalException {
        CTCollection undoCTCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        if (undoCTCollection.getStatus() != 0) {
            throw new CTLocalizedException(StringBundler.concat((String[])new String[]{"Unable to undo ", undoCTCollection.getName(), " because it is not published"}), "unable-to-revert-x-because-it-is-not-published", new Serializable[]{undoCTCollection.getName()});
        }
        if (!this._ctSchemaVersionLocalService.isLatestCTSchemaVersion(undoCTCollection.getSchemaVersionId())) {
            throw new CTLocalizedException(StringBundler.concat((String[])new String[]{"Unable to undo ", undoCTCollection.getName(), " because it is out of date with the current release"}), "unable-to-revert-x-because-it-is-out-of-date-with-the-current-release", new Serializable[]{undoCTCollection.getName()});
        }
        CTCollection newCTCollection = this.addCTCollection(null, undoCTCollection.getCompanyId(), userId, undoCTCollection.getCtRemoteId(), name, description);
        CTPreferences ctPreferences = this._ctPreferencesLocalService.getCTPreferences(undoCTCollection.getCompanyId(), userId);
        ctPreferences.setCtCollectionId(newCTCollection.getCtCollectionId());
        ctPreferences.setPreviousCtCollectionId(0L);
        this._ctPreferencesPersistence.update((BaseModel)ctPreferences);
        List publishedCTEntries = this._ctEntryPersistence.findByCtCollectionId(undoCTCollection.getCtCollectionId());
        HashMap ctServiceCopiers = new HashMap();
        long batchCounter = this.counterLocalService.increment(CTEntry.class.getName(), publishedCTEntries.size());
        batchCounter -= (long)publishedCTEntries.size();
        for (CTEntry publishedCTEntry : publishedCTEntries) {
            long modelClassNameId = publishedCTEntry.getModelClassNameId();
            CTServiceCopier ctServiceCopier = (CTServiceCopier)ctServiceCopiers.get(modelClassNameId);
            if (ctServiceCopier == null) {
                CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
                if (ctService == null) {
                    throw new CTLocalizedException(StringBundler.concat((Object[])new Object[]{"Unable to undo ", undoCTCollection.getName(), " because service for ", modelClassNameId, " is missing"}), "unable-to-revert-x-because-service-for-x-is-missing", new Serializable[]{undoCTCollection.getName(), Long.valueOf(publishedCTEntry.getModelClassNameId())});
                }
                ctServiceCopier = new CTServiceCopier(ctService, undoCTCollection.getCtCollectionId(), newCTCollection.getCtCollectionId());
                ctServiceCopiers.put(modelClassNameId, ctServiceCopier);
            }
            CTEntry ctEntry = this._ctEntryPersistence.create(++batchCounter);
            ctEntry.setCompanyId(newCTCollection.getCompanyId());
            ctEntry.setUserId(newCTCollection.getUserId());
            ctEntry.setCtCollectionId(newCTCollection.getCtCollectionId());
            ctEntry.setModelClassNameId(modelClassNameId);
            ctEntry.setModelClassPK(publishedCTEntry.getModelClassPK());
            ctEntry.setModelMvccVersion(publishedCTEntry.getModelMvccVersion());
            int changeType = publishedCTEntry.getChangeType();
            if (changeType == 0) {
                changeType = 1;
            } else if (changeType == 1) {
                changeType = 0;
            }
            ctEntry.setChangeType(changeType);
            ctServiceCopier.addCTEntry(this._ctEntryLocalService.updateCTEntry(ctEntry));
        }
        try {
            for (CTServiceCopier ctServiceCopier : ctServiceCopiers.values()) {
                ctServiceCopier.copy();
            }
            for (CTTableMapperHelper ctTableMapperHelper : this._ctServiceRegistry.getCTTableMapperHelpers()) {
                ctTableMapperHelper.undo(undoCTCollection.getCtCollectionId(), newCTCollection.getCtCollectionId());
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        List newCTEntries = this._ctEntryLocalService.getCTCollectionCTEntries(newCTCollection.getCtCollectionId());
        if (newCTEntries.size() != publishedCTEntries.size()) {
            throw new SystemException(StringBundler.concat((Object[])new Object[]{"Expected ", publishedCTEntries.size(), " change tracking entries instead of ", newCTEntries.size()}));
        }
        this._ctServiceRegistry.onAfterCopy(undoCTCollection, newCTCollection);
        return newCTCollection;
    }

    @Indexable(type=IndexableType.REINDEX)
    public CTCollection updateCTCollection(long userId, long ctCollectionId, String name, String description) throws PortalException {
        this._validate(name, description);
        CTCollection ctCollection = this.ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        Date modifiedDate = new Date();
        ctCollection.setModifiedDate(modifiedDate);
        ctCollection.setName(name);
        ctCollection.setDescription(description);
        ctCollection.setStatusByUserId(userId);
        ctCollection.setStatusDate(modifiedDate);
        return (CTCollection)this.ctCollectionPersistence.update((BaseModel)ctCollection);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._constraintResolverServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, ConstraintResolver.class, null, (serviceReference, emitter) -> {
            ConstraintResolver constraintResolver = (ConstraintResolver)bundleContext.getService(serviceReference);
            emitter.emit((Object)new ConstraintResolverKey(constraintResolver.getModelClass(), constraintResolver.getUniqueIndexColumnNames()));
        });
        this._ctDisplayRendererServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CTDisplayRenderer.class, null, (serviceReference, emitter) -> {
            CTDisplayRenderer ctDisplayRenderer = (CTDisplayRenderer)bundleContext.getService(serviceReference);
            Class modelClass = ctDisplayRenderer.getModelClass();
            emitter.emit((Object)modelClass.getName());
        });
        this._ctEntryConflictHelperServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, CTEntryConflictHelper.class, null, (serviceReference, emitter) -> {
            CTEntryConflictHelper ctEntryConflictHelper = (CTEntryConflictHelper)bundleContext.getService(serviceReference);
            Class modelClass = ctEntryConflictHelper.getModelClass();
            emitter.emit((Object)modelClass.getName());
        });
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._constraintResolverServiceTrackerMap.close();
        this._ctDisplayRendererServiceTrackerMap.close();
        this._ctEntryConflictHelperServiceTrackerMap.close();
    }

    private void _discardCTEntries(CTCollection ctCollection, long classNameId, List<CTEntry> ctEntries, boolean force) throws PortalException {
        int batchSize;
        if (ListUtil.isEmpty(ctEntries)) {
            return;
        }
        CTService<?> ctService = this._ctServiceRegistry.getCTService(classNameId);
        ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            this._processDiscardEntriesQuery(ctCollection.getCtCollectionId(), ctEntries, (CTPersistence<?>)ctPersistence, primaryKeyName);
            return null;
        });
        ArrayList<Long> modelClassPKs = new ArrayList<Long>(ctEntries.size());
        for (CTEntry ctEntry : ctEntries) {
            modelClassPKs.add(ctEntry.getModelClassPK());
            this._ctEntryLocalService.deleteCTEntry(ctEntry, force);
        }
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)ctCollection.getCtCollectionId());){
            CTPersistence ctPersistence2 = ctService.getCTPersistence();
            ctPersistence2.clearCache(new HashSet(modelClassPKs));
        }
        for (int processedClassPKs = 0; processedClassPKs < modelClassPKs.size(); processedClassPKs += batchSize) {
            batchSize = Math.min(modelClassPKs.size() - processedClassPKs, 1000);
            for (CTAutoResolutionInfo ctAutoResolutionInfo : this._ctAutoResolutionInfoPersistence.findByC_MCNI_SMCPK(ctCollection.getCtCollectionId(), classNameId, ArrayUtil.toLongArray(modelClassPKs.subList(processedClassPKs, processedClassPKs + batchSize)))) {
                this._ctAutoResolutionInfoPersistence.remove((BaseModel)ctAutoResolutionInfo);
            }
        }
        Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
        if (indexer != null) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ArrayList<String> uids = new ArrayList<String>(ctEntries.size());
                for (CTEntry ctEntry : ctEntries) {
                    if (ctEntry.getChangeType() == 1) continue;
                    uids.add(this._uidFactory.getUID(indexer.getClassName(), (Serializable)Long.valueOf(ctEntry.getModelClassPK()), ctEntry.getCtCollectionId()));
                }
                this._indexWriterHelper.deleteDocuments(ctCollection.getCompanyId(), uids, indexer.isCommitImmediately());
                return null;
            });
        }
    }

    private Map<Long, List<CTEntry>> _getRelatedCTEntriesMap(CTCollection ctCollection, long modelClassNameId, long modelClassPK) throws PortalException {
        int count = this._ctEntryPersistence.countByC_MCNI_MCPK(ctCollection.getCtCollectionId(), modelClassNameId, modelClassPK);
        if (count == 0) {
            throw new CTEnclosureException(StringBundler.concat((Object[])new Object[]{"Unable to find CTEntry for {classNameId=", modelClassNameId, ", classPK=", modelClassPK, ", ctCollectionId=", ctCollection.getCtCollectionId(), "}"}));
        }
        CTClosure ctClosure = this._ctClosureFactory.create(ctCollection.getCtCollectionId(), modelClassNameId);
        Map<Long, Set<Long>> enclosureMap = CTEnclosureUtil.getEnclosureMap(ctClosure, modelClassNameId, modelClassPK);
        HashMap<Long, List<CTEntry>> relatedEntriesMap = new HashMap<Long, List<CTEntry>>();
        for (Map.Entry<Long, Set<Long>> enclosureEntry : enclosureMap.entrySet()) {
            long classNameId = enclosureEntry.getKey();
            Set<Long> classPKs = enclosureEntry.getValue();
            ArrayList<CTEntry> ctEntries = new ArrayList<CTEntry>(classPKs.size());
            for (long classPK : classPKs) {
                CTEntry ctEntry = this._ctEntryPersistence.fetchByC_MCNI_MCPK(ctCollection.getCtCollectionId(), classNameId, classPK);
                if (ctEntry == null) continue;
                ctEntries.add(ctEntry);
            }
            if (ctEntries.isEmpty()) continue;
            relatedEntriesMap.put(classNameId, ctEntries);
        }
        return relatedEntriesMap;
    }

    private int[] _getStatuses(long ctCollectionId, CTPersistence ctPersistence, Map.Entry<Long, CTPersistence<?>> entry) {
        CTCollection ctCollection = this.ctCollectionPersistence.fetchByPrimaryKey(ctCollectionId);
        long groupId = 0L;
        if (entry instanceof GroupedModel) {
            GroupedModel groupedModel = (GroupedModel)entry;
            groupId = groupedModel.getGroupId();
        }
        Class clazz = ctPersistence.getModelClass();
        if (!this._workflowDefinitionLinkLocalService.hasWorkflowDefinitionLink(ctCollection.getCompanyId(), groupId, clazz.getName())) {
            return new int[]{0, 2, 3, 8, 7};
        }
        return new int[]{0, 3, 8, 7};
    }

    private void _moveCTEntries(long companyId, long fromCTCollectionId, long toCTCollectionId, long classNameId, List<CTEntry> ctEntries) {
        int batchSize;
        if (ListUtil.isEmpty(ctEntries)) {
            return;
        }
        CTService<?> ctService = this._ctServiceRegistry.getCTService(classNameId);
        ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            this._processMoveCTEntriesQuery(fromCTCollectionId, toCTCollectionId, ctEntries, (CTPersistence<?>)ctPersistence, primaryKeyName);
            return null;
        });
        ArrayList<Long> modelClassPKs = new ArrayList<Long>(ctEntries.size());
        for (CTEntry ctEntry : ctEntries) {
            modelClassPKs.add(ctEntry.getModelClassPK());
            ctEntry.setCtCollectionId(toCTCollectionId);
            this._ctEntryLocalService.updateCTEntry(ctEntry);
        }
        CTPersistence ctPersistence2 = ctService.getCTPersistence();
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)fromCTCollectionId);){
            ctPersistence2.clearCache(new HashSet(modelClassPKs));
        }
        safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)toCTCollectionId);
        try {
            ctPersistence2.clearCache(new HashSet(modelClassPKs));
        }
        finally {
            if (safeCloseable != null) {
                safeCloseable.close();
            }
        }
        for (int processedClassPKs = 0; processedClassPKs < modelClassPKs.size(); processedClassPKs += batchSize) {
            batchSize = Math.min(modelClassPKs.size() - processedClassPKs, 1000);
            for (CTAutoResolutionInfo ctAutoResolutionInfo : this._ctAutoResolutionInfoPersistence.findByC_MCNI_SMCPK(fromCTCollectionId, classNameId, ArrayUtil.toLongArray(modelClassPKs.subList(processedClassPKs, processedClassPKs + batchSize)))) {
                ctAutoResolutionInfo.setCtCollectionId(toCTCollectionId);
                this._ctAutoResolutionInfoPersistence.update((BaseModel)ctAutoResolutionInfo);
            }
        }
        Indexer indexer = this._indexerRegistry.getIndexer(ctService.getModelClass());
        if (indexer != null) {
            TransactionCommitCallbackUtil.registerCallback(() -> {
                ArrayList<String> uids = new ArrayList<String>(ctEntries.size());
                for (CTEntry ctEntry : ctEntries) {
                    if (ctEntry.getChangeType() == 1) continue;
                    uids.add(this._uidFactory.getUID(indexer.getClassName(), (Serializable)Long.valueOf(ctEntry.getModelClassPK()), fromCTCollectionId));
                    SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)toCTCollectionId);
                    try {
                        indexer.reindex(indexer.getClassName(), ctEntry.getModelClassPK());
                    }
                    finally {
                        if (safeCloseable == null) continue;
                        safeCloseable.close();
                    }
                }
                this._indexWriterHelper.deleteDocuments(companyId, uids, indexer.isCommitImmediately());
                return null;
            });
        }
    }

    private void _processDiscardEntriesQuery(long ctCollectionId, List<CTEntry> ctEntries, CTPersistence<?> ctPersistence, String primaryKeyName) {
        StringBundler sb = new StringBundler(7);
        sb.append("delete from ");
        sb.append(ctPersistence.getTableName());
        sb.append(" where ctCollectionId = ");
        sb.append(ctCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" = ?");
        Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)sb.toString());){
            for (CTEntry ctEntry : ctEntries) {
                preparedStatement.setLong(1, ctEntry.getModelClassPK());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        for (String mappingTableName : ctPersistence.getMappingTableNames()) {
            sb.setStringAt(mappingTableName, 1);
            try {
                PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)sb.toString());
                try {
                    for (CTEntry ctEntry : ctEntries) {
                        preparedStatement.setLong(1, ctEntry.getModelClassPK());
                        preparedStatement.addBatch();
                    }
                    preparedStatement.executeBatch();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
    }

    private void _processMoveCTEntriesQuery(long fromCTCollectionId, long toCTCollectionId, List<CTEntry> ctEntries, CTPersistence<?> ctPersistence, String primaryKeyName) {
        StringBundler sb = new StringBundler(9);
        sb.append("update ");
        sb.append(ctPersistence.getTableName());
        sb.append(" set ctCollectionId = ");
        sb.append(toCTCollectionId);
        sb.append(" where ctCollectionId = ");
        sb.append(fromCTCollectionId);
        sb.append(" and ");
        sb.append(primaryKeyName);
        sb.append(" = ?");
        Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
        try (PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)sb.toString());){
            for (CTEntry ctEntry : ctEntries) {
                preparedStatement.setLong(1, ctEntry.getModelClassPK());
                preparedStatement.addBatch();
            }
            preparedStatement.executeBatch();
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
        for (String mappingTableName : ctPersistence.getMappingTableNames()) {
            sb.setStringAt(mappingTableName, 1);
            try {
                PreparedStatement preparedStatement = AutoBatchPreparedStatementUtil.autoBatch((Connection)connection, (String)sb.toString());
                try {
                    for (CTEntry ctEntry : ctEntries) {
                        preparedStatement.setLong(1, ctEntry.getModelClassPK());
                        preparedStatement.addBatch();
                    }
                    preparedStatement.executeBatch();
                }
                finally {
                    if (preparedStatement == null) continue;
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {
                throw new SystemException((Throwable)exception);
            }
        }
    }

    private void _validate(String name, String description) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new CTCollectionNameException();
        }
        int nameMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"name");
        if (name.length() > nameMaxLength) {
            throw new CTCollectionNameException("Name is too long");
        }
        int descriptionMaxLength = ModelHintsUtil.getMaxLength((String)CTCollection.class.getName(), (String)"description");
        if (description != null && description.length() > descriptionMaxLength) {
            throw new CTCollectionDescriptionException("Description is too long");
        }
    }
}

