/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.model.impl;

import com.liferay.change.tracking.model.CTPreferences;
import com.liferay.change.tracking.service.CTPreferencesLocalServiceUtil;

/**
 * The extended model base implementation for the CTPreferences service. Represents a row in the &quot;CTPreferences&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link CTPreferencesImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see CTPreferencesImpl
 * @see CTPreferences
 * @generated
 */
public abstract class CTPreferencesBaseImpl
	extends CTPreferencesModelImpl implements CTPreferences {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a ct preferences model instance should use the <code>CTPreferences</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			CTPreferencesLocalServiceUtil.addCTPreferences(this);
		}
		else {
			CTPreferencesLocalServiceUtil.updateCTPreferences(this);
		}
	}

}