/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTRemote;
import com.liferay.change.tracking.service.base.CTRemoteLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.ResourceLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTRemote"}, service={AopService.class})
public class CTRemoteLocalServiceImpl
extends CTRemoteLocalServiceBaseImpl {
    @Reference
    private ResourceLocalService _resourceLocalService;
    @Reference
    private UserLocalService _userLocalService;

    @Indexable(type=IndexableType.REINDEX)
    public CTRemote addCTRemote(long userId, String name, String description, String url, String clientId, String clientSecret) throws PortalException {
        long ctRemoteId = this.counterLocalService.increment(CTRemote.class.getName());
        CTRemote ctRemote = this.ctRemotePersistence.create(ctRemoteId);
        User user = this._userLocalService.getUser(userId);
        ctRemote.setCompanyId(user.getCompanyId());
        ctRemote.setUserId(userId);
        ctRemote.setName(name);
        ctRemote.setDescription(description);
        ctRemote.setUrl(url);
        ctRemote.setClientId(clientId);
        ctRemote.setClientSecret(clientSecret);
        ctRemote = (CTRemote)this.ctRemotePersistence.update((BaseModel)ctRemote);
        this._resourceLocalService.addResources(ctRemote.getCompanyId(), 0L, ctRemote.getUserId(), CTRemote.class.getName(), ctRemote.getCtRemoteId(), false, false, false);
        return ctRemote;
    }

    @Override
    public CTRemote fetchCTRemote(long ctRemoteId) {
        return this.ctRemotePersistence.fetchByPrimaryKey(ctRemoteId);
    }

    public List<CTRemote> getCTRemotes(long companyId) {
        return this.ctRemotePersistence.findByCompanyId(companyId);
    }

    public List<CTRemote> getCTRemotes(long companyId, int start, int end) {
        return this.ctRemotePersistence.findByCompanyId(companyId, start, end);
    }

    @Indexable(type=IndexableType.REINDEX)
    public CTRemote updateCTRemote(long ctRemoteId, String name, String description, String url, String clientId, String clientSecret) throws PortalException {
        CTRemote ctRemote = this.ctRemotePersistence.findByPrimaryKey(ctRemoteId);
        ctRemote.setName(name);
        ctRemote.setDescription(description);
        ctRemote.setUrl(url);
        ctRemote.setClientId(clientId);
        ctRemote.setClientSecret(clientSecret);
        return (CTRemote)this.ctRemotePersistence.update((BaseModel)ctRemote);
    }
}

