/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.resolver;

import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.petra.function.UnsafeSupplier;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;

public class ConstraintResolverContextImpl<T extends CTModel<T>>
implements ConstraintResolverContext<T> {
    private final CTService<T> _ctService;
    private final long _sourceCTCollectionId;
    private long _sourcePrimaryKey;
    private final long _targetCTCollectionId;
    private long _targetPrimaryKey;

    public ConstraintResolverContextImpl(CTService<T> ctService, long sourceCTCollectionId, long targetCTCollectionId) {
        this._ctService = ctService;
        this._sourceCTCollectionId = sourceCTCollectionId;
        this._targetCTCollectionId = targetCTCollectionId;
    }

    public <R, E extends Throwable> R getInTarget(UnsafeSupplier<R, E> unsafeSupplier) throws E {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)this._targetCTCollectionId);){
            Object object = unsafeSupplier.get();
            return (R)object;
        }
    }

    public T getSourceCTModel() {
        return (T)((CTModel)this._ctService.updateWithUnsafeFunction(ctPersistence -> (CTModel)ctPersistence.fetchByPrimaryKey((Serializable)Long.valueOf(this._sourcePrimaryKey))));
    }

    public T getTargetCTModel() {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)this._targetCTCollectionId);){
            CTModel cTModel = (CTModel)this._ctService.updateWithUnsafeFunction(ctPersistence -> (CTModel)ctPersistence.fetchByPrimaryKey((Serializable)Long.valueOf(this._targetPrimaryKey)));
            return (T)cTModel;
        }
    }

    public boolean isSourceCTModel(CTModel<?> ctModel) {
        return ctModel.getCtCollectionId() == this._sourceCTCollectionId;
    }

    public boolean isTargetCTModel(CTModel<?> ctModel) {
        return ctModel.getCtCollectionId() == this._targetCTCollectionId;
    }

    public void mergeSourceCTModelIntoTargetCTModel() {
        Object sourceCTModel = this.getSourceCTModel();
        Map sourceModelAttributes = sourceCTModel.getModelAttributes();
        Object targetCTModel = this.getTargetCTModel();
        Map targetModelAttributes = targetCTModel.getModelAttributes();
        this._ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set ctColumnNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.MERGE);
            ctColumnNames.add("classPK");
            for (String ctColumnName : ctColumnNames) {
                targetModelAttributes.put(ctColumnName, sourceModelAttributes.get(ctColumnName));
            }
            targetCTModel.setModelAttributes(targetModelAttributes);
            ctPersistence.remove((BaseModel)sourceCTModel);
            ctPersistence.flush();
            return (CTModel)ctPersistence.update((BaseModel)targetCTModel);
        });
    }

    public void setPrimaryKeys(long sourcePrimaryKey, long targetPrimaryKey) {
        this._sourcePrimaryKey = sourcePrimaryKey;
        this._targetPrimaryKey = targetPrimaryKey;
    }
}

