/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.helper;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.petra.function.transform.TransformUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.model.UserGroupRoleModel;
import com.liferay.portal.kernel.notifications.UserNotificationManagerUtil;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.kernel.service.UserGroupRoleLocalService;
import com.liferay.portal.kernel.service.UserNotificationEventLocalService;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.Portal;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTUserNotificationHelper.class})
public class CTUserNotificationHelper {
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Portal _portal;
    @Reference
    private RoleLocalService _roleLocalService;
    @Reference
    private UserGroupRoleLocalService _userGroupRoleLocalService;
    @Reference
    private UserNotificationEventLocalService _userNotificationEventLocalService;

    public long[] getPublicationRoleUserIds(CTCollection ctCollection, boolean includeOwner, String ... publicationRoleNames) {
        Group group;
        HashSet<Long> userIds = new HashSet<Long>();
        if (includeOwner) {
            userIds.add(ctCollection.getUserId());
        }
        if ((group = this._groupLocalService.fetchGroup(ctCollection.getCompanyId(), this._portal.getClassNameId(CTCollection.class), ctCollection.getCtCollectionId())) == null) {
            return ArrayUtil.toLongArray(userIds);
        }
        for (String publicationRoleName : publicationRoleNames) {
            Role role = this._roleLocalService.fetchRole(group.getCompanyId(), publicationRoleName);
            if (role == null) continue;
            userIds.addAll(TransformUtil.transform((Collection)this._userGroupRoleLocalService.getUserGroupRolesByGroupAndRole(group.getGroupId(), role.getRoleId()), UserGroupRoleModel::getUserId));
        }
        return ArrayUtil.toLongArray(userIds);
    }

    public void sendUserNotificationEvents(CTCollection ctCollection, JSONObject notificationEventJSONObject, long[] userIds) throws PortalException {
        for (long userId : userIds) {
            if (!UserNotificationManagerUtil.isDeliver((long)userId, (String)"com_liferay_change_tracking_web_portlet_PublicationsPortlet", (long)0L, (int)2, (int)10002)) continue;
            this._userNotificationEventLocalService.sendUserNotificationEvents(userId, "com_liferay_change_tracking_web_portlet_PublicationsPortlet", 10002, false, notificationEventJSONObject);
        }
    }
}

