/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.closure;

import com.liferay.change.tracking.closure.CTClosure;
import com.liferay.change.tracking.internal.closure.Node;
import com.liferay.petra.string.StringBundler;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CTClosureImpl
implements CTClosure {
    private final Map<Node, Collection<Node>> _closureMap;
    private final long _ctCollectionId;

    public CTClosureImpl(long ctCollectionId, Map<Node, Collection<Node>> closureMap) {
        this._ctCollectionId = ctCollectionId;
        this._closureMap = closureMap;
    }

    public Map<Long, List<Long>> getChildPKsMap(long classNameId, long classPK) {
        Collection<Node> nodes = this._closureMap.get(new Node(classNameId, classPK));
        if (nodes == null) {
            return Collections.emptyMap();
        }
        HashSet<Node> excludedNodes = new HashSet<Node>();
        LinkedList<Node> queue = new LinkedList<Node>(nodes);
        while (queue.size() > 0) {
            Collection<Node> childNodes = this._closureMap.get(queue.poll());
            if (childNodes == null) continue;
            for (Node childNode : childNodes) {
                if (!excludedNodes.add(childNode)) continue;
                queue.add(childNode);
            }
        }
        return this._getPrimaryKeysMap(nodes, excludedNodes);
    }

    public long getCTCollectionId() {
        return this._ctCollectionId;
    }

    public Map<Long, List<Long>> getRootPKsMap() {
        return this._getPrimaryKeysMap(this._closureMap.get(Node.ROOT_NODE), Collections.emptySet());
    }

    public String toString() {
        StringBundler sb1 = new StringBundler();
        sb1.append("{\n");
        Map<Long, List<Long>> pksMap = this.getRootPKsMap();
        LinkedList<AbstractMap.SimpleImmutableEntry<Map.Entry<Long, List<Long>>, Integer>> queue = new LinkedList<AbstractMap.SimpleImmutableEntry<Map.Entry<Long, List<Long>>, Integer>>();
        for (Map.Entry<Long, List<Long>> entry : pksMap.entrySet()) {
            queue.add(new AbstractMap.SimpleImmutableEntry<Map.Entry<Long, List<Long>>, Integer>(entry, 1));
        }
        Map.Entry indentEntry = null;
        while ((indentEntry = (Map.Entry)queue.poll()) != null) {
            Map.Entry entry = (Map.Entry)indentEntry.getKey();
            long classNameId = (Long)entry.getKey();
            int indent = (Integer)indentEntry.getValue();
            StringBundler sb2 = new StringBundler(indent);
            for (int i = 0; i < indent; ++i) {
                sb2.append('\t');
            }
            String indentString = sb2.toString();
            Iterator iterator = ((Collection)entry.getValue()).iterator();
            while (iterator.hasNext()) {
                long classPK = (Long)iterator.next();
                sb1.append(indentString);
                sb1.append("(classNameId=");
                sb1.append(classNameId);
                sb1.append(", classPK=");
                sb1.append(classPK);
                sb1.append(")\n");
                Map<Long, List<Long>> childPKsMap = this.getChildPKsMap(classNameId, classPK);
                for (Map.Entry<Long, List<Long>> childEntry : childPKsMap.entrySet()) {
                    queue.addFirst(new AbstractMap.SimpleImmutableEntry<Map.Entry<Long, List<Long>>, Integer>(childEntry, indent + 1));
                }
            }
        }
        sb1.append("}");
        return sb1.toString();
    }

    private Map<Long, List<Long>> _getPrimaryKeysMap(Collection<Node> nodes, Set<Node> excludedNodes) {
        HashMap<Long, List<Long>> primaryKeysMap = new HashMap<Long, List<Long>>();
        for (Node node : nodes) {
            if (excludedNodes.contains(node)) continue;
            List primaryKeys = primaryKeysMap.computeIfAbsent(node.getClassNameId(), key -> new ArrayList());
            primaryKeys.add(node.getPrimaryKey());
        }
        return primaryKeysMap;
    }
}

