/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.reference;

import com.liferay.change.tracking.internal.reference.TableJoinHolder;
import com.liferay.change.tracking.internal.reference.TableUtil;
import com.liferay.change.tracking.spi.reference.TableReferenceDefinition;
import com.liferay.petra.sql.dsl.Column;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.ast.ASTNode;
import com.liferay.petra.sql.dsl.ast.ASTNodeListener;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.expression.Predicate;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.petra.sql.dsl.query.FromStep;
import com.liferay.petra.sql.dsl.query.JoinStep;
import com.liferay.petra.sql.dsl.query.WhereStep;
import com.liferay.petra.sql.dsl.spi.expression.DSLFunction;
import com.liferay.petra.sql.dsl.spi.expression.DefaultPredicate;
import com.liferay.petra.sql.dsl.spi.expression.Operand;
import com.liferay.petra.sql.dsl.spi.expression.Scalar;
import com.liferay.petra.sql.dsl.spi.query.From;
import com.liferay.petra.sql.dsl.spi.query.Join;
import com.liferay.petra.sql.dsl.spi.query.JoinType;
import com.liferay.petra.string.StringBundler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;

public class TableJoinHolderFactory {
    private static final Consumer<String> _emptyStringConsumer = string -> {};
    private static final FromStep _validationFromStep = new ValidationFromStep();
    private static final Set<Operand> _validOperands = new HashSet<Operand>(Arrays.asList(Operand.AND, Operand.EQUAL, Operand.LIKE));

    public static <T extends Table<T>> TableJoinHolder create(Function<FromStep, JoinStep> joinFunction, boolean parent, Column<T, Long> primaryKeyColumn, TableReferenceDefinition<T> tableReferenceDefinition) {
        JoinStep joinStep = joinFunction.apply(_validationFromStep);
        if (!(joinStep instanceof Join)) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Missing join in \"", joinStep, "\""}));
        }
        JoinStepASTNodeListener<Table> joinStepASTNodeListener = new JoinStepASTNodeListener<Table>(tableReferenceDefinition.getTable());
        joinStep.toSQL(_emptyStringConsumer, joinStepASTNodeListener);
        if (joinStepASTNodeListener._fromTable == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Join function must use provided from step for join step ", "\"", joinStep, "\""}));
        }
        if (!joinStepASTNodeListener._hasRequiredTable) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Required table \"", tableReferenceDefinition.getTable(), "\" is unused in join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidJoin != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid join for join step \"", joinStep, "\", ensure table alias is used for self joins"}));
        }
        if (joinStepASTNodeListener._invalidJoinOrder) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"First join must be on table \"", tableReferenceDefinition.getTable(), "\" for join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidJoinType != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid join type \"", joinStepASTNodeListener._invalidJoinType, "\" for join step \"", joinStep, "\""}));
        }
        if (joinStepASTNodeListener._invalidOperand != null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Invalid predicate operand \"", joinStepASTNodeListener._invalidOperand, "\" for join step \"", joinStep, "\""}));
        }
        if (!joinStepASTNodeListener._tables.containsAll(joinStepASTNodeListener._columnTables)) {
            ArrayList columnTables = new ArrayList(joinStepASTNodeListener._columnTables);
            Comparator<Table> comparator = Comparator.comparing(Table::getName);
            columnTables.sort(comparator);
            ArrayList joinTables = new ArrayList(joinStepASTNodeListener._tables);
            joinTables.sort(comparator);
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"Predicate column tables ", columnTables, " do not match join tables ", joinTables, " for join step \"", joinStep, "\""}));
        }
        Column<?, Long> fromPKColumn = TableUtil.getPrimaryKeyColumn(joinStepASTNodeListener._fromTable);
        if (fromPKColumn == null) {
            throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"No long type primary key column found for table \"", joinStepASTNodeListener._fromTable, "\" for join step \"", joinStep, "\""}));
        }
        WhereStep missingRequirementWhereStep = null;
        Predicate missingRequirementWherePredicate = null;
        if (parent) {
            missingRequirementWherePredicate = fromPKColumn.isNull();
            List<BridgePredicate> bridgePredicates = TableJoinHolderFactory._getBridgePredicates(joinStep);
            Set<Column<?, ?>> childColumns = TableJoinHolderFactory._getChildColumns(primaryKeyColumn.getTable(), joinStep);
            Iterator<BridgePredicate> iterator = bridgePredicates.iterator();
            while (iterator.hasNext()) {
                BridgePredicate bridgePredicate = iterator.next();
                if (!bridgePredicate.hasOnlyTable(primaryKeyColumn.getTable())) continue;
                missingRequirementWherePredicate = missingRequirementWherePredicate.and((Expression)bridgePredicate._predicate);
                iterator.remove();
            }
            missingRequirementWhereStep = TableJoinHolderFactory._getMissingRequirementWhereStep(primaryKeyColumn, fromPKColumn, bridgePredicates);
            for (Column<?, ?> column : childColumns) {
                Class clazz = column.getJavaType();
                missingRequirementWherePredicate = missingRequirementWherePredicate.and((Expression)column.isNotNull()).and(() -> {
                    if (clazz == String.class) {
                        Column stringColumn = column;
                        return stringColumn.neq((Object)"");
                    }
                    if (clazz != Long.class) {
                        return null;
                    }
                    Column longColumn = column;
                    return longColumn.neq((Object)0L);
                });
            }
        }
        return new TableJoinHolder(primaryKeyColumn, joinFunction, missingRequirementWherePredicate, missingRequirementWhereStep, fromPKColumn);
    }

    private static List<BridgePredicate> _getBridgePredicates(JoinStep joinStep) {
        LinkedList<BridgePredicate> bridgePredicates = new LinkedList<BridgePredicate>();
        LinkedList<DefaultPredicate> defaultPredicateQueue = new LinkedList<DefaultPredicate>();
        LinkedList<Expression> expressionQueue = new LinkedList<Expression>();
        JoinStep astNode = joinStep;
        while (astNode instanceof Join) {
            Join join = (Join)astNode;
            defaultPredicateQueue.add((DefaultPredicate)join.getOnPredicate());
            DefaultPredicate defaultPredicate = null;
            while ((defaultPredicate = (DefaultPredicate)defaultPredicateQueue.poll()) != null) {
                Expression leftExpression = defaultPredicate.getLeftExpression();
                Expression rightExpression = defaultPredicate.getRightExpression();
                if (defaultPredicate.getOperand() == Operand.AND) {
                    defaultPredicateQueue.add((DefaultPredicate)leftExpression);
                    defaultPredicateQueue.add((DefaultPredicate)rightExpression);
                    continue;
                }
                Set<Table<?>> tables = Collections.newSetFromMap(new IdentityHashMap());
                expressionQueue.add(leftExpression);
                expressionQueue.add(rightExpression);
                Expression expression = null;
                while ((expression = (Expression)expressionQueue.poll()) != null) {
                    if (expression instanceof Column) {
                        Column column = (Column)expression;
                        tables.add(column.getTable());
                        continue;
                    }
                    if (!(expression instanceof DSLFunction)) continue;
                    DSLFunction dslFunction = (DSLFunction)expression;
                    Collections.addAll(expressionQueue, dslFunction.getExpressions());
                }
                bridgePredicates.add(new BridgePredicate(tables, (Predicate)defaultPredicate));
            }
            astNode = join.getChild();
        }
        return bridgePredicates;
    }

    private static Set<Column<?, ?>> _getChildColumns(Table<?> table, JoinStep joinStep) {
        HashSet childColumns = new HashSet();
        joinStep.toSQL(_emptyStringConsumer, astNode -> {
            DefaultPredicate defaultPredicate;
            if (astNode instanceof DefaultPredicate && (defaultPredicate = (DefaultPredicate)astNode).getOperand() == Operand.EQUAL) {
                Column column;
                Expression leftExpression = defaultPredicate.getLeftExpression();
                Expression rightExpression = defaultPredicate.getRightExpression();
                if (leftExpression instanceof Column && !(rightExpression instanceof Scalar) && (column = (Column)leftExpression).getTable() == table) {
                    childColumns.add(column);
                }
                if (!(leftExpression instanceof Scalar) && rightExpression instanceof Column && (column = (Column)rightExpression).getTable() == table) {
                    childColumns.add(column);
                }
            }
        });
        return childColumns;
    }

    private static WhereStep _getMissingRequirementWhereStep(Column<?, Long> primaryKeyColumn, Column<?, Long> fromPKColumn, List<BridgePredicate> bridgePredicates) {
        Table parentTable = fromPKColumn.getTable();
        JoinStep joinStep = DSLQueryFactoryUtil.select((Expression[])new Expression[]{primaryKeyColumn, new Scalar((Object)parentTable.getTableName())}).from(primaryKeyColumn.getTable());
        Set tables = Collections.newSetFromMap(new IdentityHashMap());
        tables.add(primaryKeyColumn.getTable());
        HashSet<BridgePredicate> resolvedBridgePredicates = new HashSet<BridgePredicate>();
        int previousSize = -1;
        while (resolvedBridgePredicates.size() != previousSize) {
            previousSize = resolvedBridgePredicates.size();
            for (BridgePredicate bridgePredicate : bridgePredicates) {
                if (resolvedBridgePredicates.contains(bridgePredicate)) continue;
                Table<?> table = null;
                for (Table<?> predicateTable : bridgePredicate._tables) {
                    if (tables.contains(predicateTable)) continue;
                    if (table != null) {
                        table = null;
                        break;
                    }
                    table = predicateTable;
                }
                if (table == null) continue;
                tables.add(table);
                Predicate predicate = null;
                for (BridgePredicate currentBridgePredicate : bridgePredicates) {
                    if (resolvedBridgePredicates.contains(currentBridgePredicate) || !tables.containsAll(currentBridgePredicate._tables)) continue;
                    resolvedBridgePredicates.add(currentBridgePredicate);
                    if (predicate == null) {
                        predicate = currentBridgePredicate._predicate;
                        continue;
                    }
                    predicate = predicate.and((Expression)currentBridgePredicate._predicate);
                }
                joinStep = joinStep.leftJoinOn(table, predicate);
            }
        }
        if (!resolvedBridgePredicates.containsAll(bridgePredicates)) {
            StringBundler sb = new StringBundler();
            sb.append("Unable to apply predicates [");
            for (BridgePredicate bridgePredicate : bridgePredicates) {
                if (resolvedBridgePredicates.contains(bridgePredicate)) continue;
                sb.append((Object)bridgePredicate._predicate);
                sb.append(", ");
            }
            sb.setStringAt("] to ", sb.index() - 1);
            sb.append((Object)joinStep);
            throw new IllegalArgumentException(sb.toString());
        }
        return joinStep;
    }

    private static class JoinStepASTNodeListener<T extends Table<T>>
    implements ASTNodeListener {
        private final Set<Table<?>> _columnTables = Collections.newSetFromMap(new IdentityHashMap());
        private Table<?> _fromTable;
        private boolean _hasRequiredTable;
        private Join _invalidJoin;
        private boolean _invalidJoinOrder;
        private JoinType _invalidJoinType;
        private Operand _invalidOperand;
        private final T _table;
        private final Set<Table<?>> _tables = Collections.newSetFromMap(new IdentityHashMap());

        public void process(ASTNode astNode) {
            if (astNode instanceof Column) {
                Column column = (Column)astNode;
                this._columnTables.add(column.getTable());
                if (!this._hasRequiredTable && Objects.equals(this._table, column.getTable())) {
                    this._hasRequiredTable = true;
                }
            } else if (astNode instanceof DefaultPredicate) {
                DefaultPredicate defaultPredicate = (DefaultPredicate)astNode;
                Operand operand = defaultPredicate.getOperand();
                if (!_validOperands.contains(operand) && this._invalidOperand == null) {
                    this._invalidOperand = operand;
                }
            } else if (astNode instanceof From) {
                From from = (From)astNode;
                if (from.getChild() == _validationFromStep) {
                    this._fromTable = from.getTable();
                    this._tables.add(from.getTable());
                }
            } else if (astNode instanceof Join) {
                Join join = (Join)astNode;
                JoinType joinType = join.getJoinType();
                if (joinType != JoinType.INNER) {
                    this._invalidJoinType = joinType;
                }
                Table table = join.getTable();
                if (this._tables.size() == 1 && table != this._table) {
                    this._invalidJoinOrder = true;
                }
                if (table.equals(this._fromTable) && Objects.equals(this._fromTable.getName(), table.getName())) {
                    this._invalidJoin = join;
                }
                this._tables.add(table);
            }
        }

        private JoinStepASTNodeListener(T table) {
            this._table = table;
        }
    }

    private static class BridgePredicate {
        private final Predicate _predicate;
        private final Set<Table<?>> _tables;

        public boolean hasOnlyTable(Table<?> childTable) {
            for (Table<?> table : this._tables) {
                if (table == childTable) continue;
                return false;
            }
            return true;
        }

        private BridgePredicate(Set<Table<?>> tables, Predicate predicate) {
            this._tables = tables;
            this._predicate = predicate;
        }
    }

    private static class ValidationFromStep
    implements FromStep {
        private ValidationFromStep() {
        }

        public Table<?> as(String name) {
            throw new UnsupportedOperationException();
        }

        public Table<?> as(String name, Collection<Column<?, ?>> templateColumns) {
            throw new UnsupportedOperationException();
        }

        public <T extends Table<T>> T as(String name, T templateTable) {
            throw new UnsupportedOperationException();
        }

        public JoinStep from(Table<?> table) {
            return new From((FromStep)this, table);
        }

        public void toSQL(Consumer<String> consumer, ASTNodeListener astNodeListener) {
            consumer.accept("...");
        }

        public DSLQuery union(DSLQuery dslQuery) {
            throw new UnsupportedOperationException();
        }

        public DSLQuery unionAll(DSLQuery dslQuery) {
            throw new UnsupportedOperationException();
        }
    }
}

