/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.change.tracking.internal.search.spi.model.index.contributor;

import com.liferay.change.tracking.model.CTProcess;
import com.liferay.change.tracking.service.CTProcessLocalService;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.search.batch.BatchIndexingActionable;
import com.liferay.portal.search.batch.DynamicQueryBatchIndexingActionableFactory;
import com.liferay.portal.search.spi.model.index.contributor.ModelIndexerWriterContributor;
import com.liferay.portal.search.spi.model.index.contributor.helper.ModelIndexerWriterDocumentHelper;

/**
 * @author Pei-Jung Lan
 */
public class CTProcessModelIndexerWriterContributor
	implements ModelIndexerWriterContributor<CTProcess> {

	public CTProcessModelIndexerWriterContributor(
		CTProcessLocalService ctProcessLocalService,
		DynamicQueryBatchIndexingActionableFactory
			dynamicQueryBatchIndexingActionableFactory) {

		_ctProcessLocalService = ctProcessLocalService;
		_dynamicQueryBatchIndexingActionableFactory =
			dynamicQueryBatchIndexingActionableFactory;
	}

	@Override
	public void customize(
		BatchIndexingActionable batchIndexingActionable,
		ModelIndexerWriterDocumentHelper modelIndexerWriterDocumentHelper) {

		batchIndexingActionable.setPerformActionMethod(
			(CTProcess ctProcess) -> batchIndexingActionable.addDocuments(
				modelIndexerWriterDocumentHelper.getDocument(ctProcess)));
	}

	@Override
	public BatchIndexingActionable getBatchIndexingActionable() {
		IndexableActionableDynamicQuery indexableActionableDynamicQuery =
			_ctProcessLocalService.getIndexableActionableDynamicQuery();

		if (!CTCollectionThreadLocal.isProductionMode()) {
			if (_log.isDebugEnabled()) {
				_log.debug(
					StringBundler.concat(
						"Restricting indexable results of ",
						CTProcess.class.getName(), " because this can only be ",
						"performed in production mode"));
			}

			indexableActionableDynamicQuery.setAddCriteriaMethod(
				dynamicQuery -> dynamicQuery.add(
					RestrictionsFactoryUtil.eq("ctCollectionId", -1L)));
		}

		return _dynamicQueryBatchIndexingActionableFactory.
			getBatchIndexingActionable(indexableActionableDynamicQuery);
	}

	@Override
	public long getCompanyId(CTProcess ctProcess) {
		return ctProcess.getCompanyId();
	}

	private static final Log _log = LogFactoryUtil.getLog(
		CTProcessModelIndexerWriterContributor.class);

	private final CTProcessLocalService _ctProcessLocalService;
	private final DynamicQueryBatchIndexingActionableFactory
		_dynamicQueryBatchIndexingActionableFactory;

}