/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTComment;
import com.liferay.change.tracking.service.base.CTCommentLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.change.tracking.model.CTComment"}, service={AopService.class})
public class CTCommentLocalServiceImpl
extends CTCommentLocalServiceBaseImpl {
    @Reference
    private CTCollectionPersistence _ctCollectionPersistence;

    public CTComment addCTComment(long userId, long ctCollectionId, long ctEntryId, String value) throws PortalException {
        CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
        CTComment ctComment = this.ctCommentPersistence.create(this.counterLocalService.increment(CTComment.class.getName()));
        ctComment.setCompanyId(ctCollection.getCompanyId());
        ctComment.setUserId(userId);
        ctComment.setCtCollectionId(ctCollectionId);
        ctComment.setCtEntryId(ctEntryId);
        ctComment.setValue(value);
        return (CTComment)this.ctCommentPersistence.update((BaseModel)ctComment);
    }

    @Override
    public CTComment deleteCTComment(long ctCommentId) {
        CTComment ctComment = this.ctCommentPersistence.fetchByPrimaryKey(ctCommentId);
        if (ctComment != null) {
            ctComment = (CTComment)this.ctCommentPersistence.remove((BaseModel)ctComment);
        }
        return ctComment;
    }

    public Map<Long, List<CTComment>> getCTCollectionCTComments(long ctCollectionId) {
        HashMap<Long, List<CTComment>> collectionCommentsMap = new HashMap<Long, List<CTComment>>();
        for (CTComment ctComment : this.ctCommentPersistence.findByCtCollectionId(ctCollectionId)) {
            List ctComments = collectionCommentsMap.computeIfAbsent(ctComment.getCtEntryId(), key -> new ArrayList());
            ctComments.add(ctComment);
        }
        return collectionCommentsMap;
    }

    public List<CTComment> getCTEntryCTComments(long ctEntryId) {
        return this.ctCommentPersistence.findByCtEntryId(ctEntryId);
    }

    public CTComment updateCTComment(long ctCommentId, String value) throws PortalException {
        CTComment ctComment = this.ctCommentPersistence.findByPrimaryKey(ctCommentId);
        ctComment.setValue(value);
        return (CTComment)this.ctCommentPersistence.update((BaseModel)ctComment);
    }
}

