/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.persistence.impl;

import com.liferay.change.tracking.exception.NoSuchCommentException;
import com.liferay.change.tracking.model.CTComment;
import com.liferay.change.tracking.model.CTCommentTable;
import com.liferay.change.tracking.model.impl.CTCommentImpl;
import com.liferay.change.tracking.model.impl.CTCommentModelImpl;
import com.liferay.change.tracking.service.persistence.CTCommentPersistence;
import com.liferay.change.tracking.service.persistence.CTCommentUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={CTCommentPersistence.class})
public class CTCommentPersistenceImpl
extends BasePersistenceImpl<CTComment>
implements CTCommentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = CTCommentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByCtCollectionId;
    private FinderPath _finderPathWithoutPaginationFindByCtCollectionId;
    private FinderPath _finderPathCountByCtCollectionId;
    private static final String _FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2 = "ctComment.ctCollectionId = ?";
    private FinderPath _finderPathWithPaginationFindByCtEntryId;
    private FinderPath _finderPathWithoutPaginationFindByCtEntryId;
    private FinderPath _finderPathCountByCtEntryId;
    private static final String _FINDER_COLUMN_CTENTRYID_CTENTRYID_2 = "ctComment.ctEntryId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_CTCOMMENT = "SELECT ctComment FROM CTComment ctComment";
    private static final String _SQL_SELECT_CTCOMMENT_WHERE = "SELECT ctComment FROM CTComment ctComment WHERE ";
    private static final String _SQL_COUNT_CTCOMMENT = "SELECT COUNT(ctComment) FROM CTComment ctComment";
    private static final String _SQL_COUNT_CTCOMMENT_WHERE = "SELECT COUNT(ctComment) FROM CTComment ctComment WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "ctComment.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No CTComment exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No CTComment exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(CTCommentPersistenceImpl.class);

    public List<CTComment> findByCtCollectionId(long ctCollectionId) {
        return this.findByCtCollectionId(ctCollectionId, -1, -1, null);
    }

    public List<CTComment> findByCtCollectionId(long ctCollectionId, int start, int end) {
        return this.findByCtCollectionId(ctCollectionId, start, end, null);
    }

    public List<CTComment> findByCtCollectionId(long ctCollectionId, int start, int end, OrderByComparator<CTComment> orderByComparator) {
        return this.findByCtCollectionId(ctCollectionId, start, end, orderByComparator, true);
    }

    public List<CTComment> findByCtCollectionId(long ctCollectionId, int start, int end, OrderByComparator<CTComment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCtCollectionId;
                finderArgs = new Object[]{ctCollectionId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCtCollectionId;
            finderArgs = new Object[]{ctCollectionId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CTComment ctComment : list) {
                if (ctCollectionId == ctComment.getCtCollectionId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_CTCOMMENT_WHERE);
            sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ctComment.ctCommentId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctCollectionId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CTComment findByCtCollectionId_First(long ctCollectionId, OrderByComparator<CTComment> orderByComparator) throws NoSuchCommentException {
        CTComment ctComment = this.fetchByCtCollectionId_First(ctCollectionId, orderByComparator);
        if (ctComment != null) {
            return ctComment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ctCollectionId=");
        sb.append(ctCollectionId);
        sb.append("}");
        throw new NoSuchCommentException(sb.toString());
    }

    public CTComment fetchByCtCollectionId_First(long ctCollectionId, OrderByComparator<CTComment> orderByComparator) {
        List<CTComment> list = this.findByCtCollectionId(ctCollectionId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTComment findByCtCollectionId_Last(long ctCollectionId, OrderByComparator<CTComment> orderByComparator) throws NoSuchCommentException {
        CTComment ctComment = this.fetchByCtCollectionId_Last(ctCollectionId, orderByComparator);
        if (ctComment != null) {
            return ctComment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ctCollectionId=");
        sb.append(ctCollectionId);
        sb.append("}");
        throw new NoSuchCommentException(sb.toString());
    }

    public CTComment fetchByCtCollectionId_Last(long ctCollectionId, OrderByComparator<CTComment> orderByComparator) {
        int count = this.countByCtCollectionId(ctCollectionId);
        if (count == 0) {
            return null;
        }
        List<CTComment> list = this.findByCtCollectionId(ctCollectionId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTComment[] findByCtCollectionId_PrevAndNext(long ctCommentId, long ctCollectionId, OrderByComparator<CTComment> orderByComparator) throws NoSuchCommentException {
        CTComment ctComment = this.findByPrimaryKey(ctCommentId);
        Session session = null;
        try {
            session = this.openSession();
            CTComment[] array = new CTCommentImpl[]{this.getByCtCollectionId_PrevAndNext(session, ctComment, ctCollectionId, orderByComparator, true), ctComment, this.getByCtCollectionId_PrevAndNext(session, ctComment, ctCollectionId, orderByComparator, false)};
            CTComment[] cTCommentArray = array;
            return cTCommentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTComment getByCtCollectionId_PrevAndNext(Session session, CTComment ctComment, long ctCollectionId, OrderByComparator<CTComment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_CTCOMMENT_WHERE);
        sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ctComment.ctCommentId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(ctCollectionId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctComment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CTComment)list.get(1);
        }
        return null;
    }

    public void removeByCtCollectionId(long ctCollectionId) {
        for (CTComment ctComment : this.findByCtCollectionId(ctCollectionId, -1, -1, null)) {
            this.remove((BaseModel)ctComment);
        }
    }

    public int countByCtCollectionId(long ctCollectionId) {
        FinderPath finderPath = this._finderPathCountByCtCollectionId;
        Object[] finderArgs = new Object[]{ctCollectionId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_CTCOMMENT_WHERE);
            sb.append(_FINDER_COLUMN_CTCOLLECTIONID_CTCOLLECTIONID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctCollectionId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<CTComment> findByCtEntryId(long ctEntryId) {
        return this.findByCtEntryId(ctEntryId, -1, -1, null);
    }

    public List<CTComment> findByCtEntryId(long ctEntryId, int start, int end) {
        return this.findByCtEntryId(ctEntryId, start, end, null);
    }

    public List<CTComment> findByCtEntryId(long ctEntryId, int start, int end, OrderByComparator<CTComment> orderByComparator) {
        return this.findByCtEntryId(ctEntryId, start, end, orderByComparator, true);
    }

    public List<CTComment> findByCtEntryId(long ctEntryId, int start, int end, OrderByComparator<CTComment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByCtEntryId;
                finderArgs = new Object[]{ctEntryId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByCtEntryId;
            finderArgs = new Object[]{ctEntryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
            for (CTComment ctComment : list) {
                if (ctEntryId == ctComment.getCtEntryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
            sb.append(_SQL_SELECT_CTCOMMENT_WHERE);
            sb.append(_FINDER_COLUMN_CTENTRYID_CTENTRYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY ctComment.ctCommentId DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctEntryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public CTComment findByCtEntryId_First(long ctEntryId, OrderByComparator<CTComment> orderByComparator) throws NoSuchCommentException {
        CTComment ctComment = this.fetchByCtEntryId_First(ctEntryId, orderByComparator);
        if (ctComment != null) {
            return ctComment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ctEntryId=");
        sb.append(ctEntryId);
        sb.append("}");
        throw new NoSuchCommentException(sb.toString());
    }

    public CTComment fetchByCtEntryId_First(long ctEntryId, OrderByComparator<CTComment> orderByComparator) {
        List<CTComment> list = this.findByCtEntryId(ctEntryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTComment findByCtEntryId_Last(long ctEntryId, OrderByComparator<CTComment> orderByComparator) throws NoSuchCommentException {
        CTComment ctComment = this.fetchByCtEntryId_Last(ctEntryId, orderByComparator);
        if (ctComment != null) {
            return ctComment;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("ctEntryId=");
        sb.append(ctEntryId);
        sb.append("}");
        throw new NoSuchCommentException(sb.toString());
    }

    public CTComment fetchByCtEntryId_Last(long ctEntryId, OrderByComparator<CTComment> orderByComparator) {
        int count = this.countByCtEntryId(ctEntryId);
        if (count == 0) {
            return null;
        }
        List<CTComment> list = this.findByCtEntryId(ctEntryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public CTComment[] findByCtEntryId_PrevAndNext(long ctCommentId, long ctEntryId, OrderByComparator<CTComment> orderByComparator) throws NoSuchCommentException {
        CTComment ctComment = this.findByPrimaryKey(ctCommentId);
        Session session = null;
        try {
            session = this.openSession();
            CTComment[] array = new CTCommentImpl[]{this.getByCtEntryId_PrevAndNext(session, ctComment, ctEntryId, orderByComparator, true), ctComment, this.getByCtEntryId_PrevAndNext(session, ctComment, ctEntryId, orderByComparator, false)};
            CTComment[] cTCommentArray = array;
            return cTCommentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTComment getByCtEntryId_PrevAndNext(Session session, CTComment ctComment, long ctEntryId, OrderByComparator<CTComment> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_CTCOMMENT_WHERE);
        sb.append(_FINDER_COLUMN_CTENTRYID_CTENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY ctComment.ctCommentId DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(ctEntryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)ctComment)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (CTComment)list.get(1);
        }
        return null;
    }

    public void removeByCtEntryId(long ctEntryId) {
        for (CTComment ctComment : this.findByCtEntryId(ctEntryId, -1, -1, null)) {
            this.remove((BaseModel)ctComment);
        }
    }

    public int countByCtEntryId(long ctEntryId) {
        FinderPath finderPath = this._finderPathCountByCtEntryId;
        Object[] finderArgs = new Object[]{ctEntryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        if (count == null) {
            StringBundler sb = new StringBundler(2);
            sb.append(_SQL_COUNT_CTCOMMENT_WHERE);
            sb.append(_FINDER_COLUMN_CTENTRYID_CTENTRYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(ctEntryId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public CTCommentPersistenceImpl() {
        this.setModelClass(CTComment.class);
        this.setModelImplClass(CTCommentImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)CTCommentTable.INSTANCE);
    }

    public void cacheResult(CTComment ctComment) {
        this.entityCache.putResult(CTCommentImpl.class, (Serializable)Long.valueOf(ctComment.getPrimaryKey()), (Serializable)ctComment);
    }

    public void cacheResult(List<CTComment> ctComments) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && ctComments.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (CTComment ctComment : ctComments) {
            if (this.entityCache.getResult(CTCommentImpl.class, (Serializable)Long.valueOf(ctComment.getPrimaryKey())) != null) continue;
            this.cacheResult(ctComment);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(CTCommentImpl.class);
        this.finderCache.clearCache(CTCommentImpl.class);
    }

    public void clearCache(CTComment ctComment) {
        this.entityCache.removeResult(CTCommentImpl.class, (BaseModel)ctComment);
    }

    public void clearCache(List<CTComment> ctComments) {
        for (CTComment ctComment : ctComments) {
            this.entityCache.removeResult(CTCommentImpl.class, (BaseModel)ctComment);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(CTCommentImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(CTCommentImpl.class, primaryKey);
        }
    }

    public CTComment create(long ctCommentId) {
        CTCommentImpl ctComment = new CTCommentImpl();
        ctComment.setNew(true);
        ctComment.setPrimaryKey(ctCommentId);
        ctComment.setCompanyId(CompanyThreadLocal.getCompanyId());
        return ctComment;
    }

    public CTComment remove(long ctCommentId) throws NoSuchCommentException {
        return this.remove(Long.valueOf(ctCommentId));
    }

    public CTComment remove(Serializable primaryKey) throws NoSuchCommentException {
        Session session = null;
        try {
            session = this.openSession();
            CTComment ctComment = (CTComment)session.get(CTCommentImpl.class, primaryKey);
            if (ctComment == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchCommentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            CTComment cTComment = (CTComment)this.remove((BaseModel)ctComment);
            return cTComment;
        }
        catch (NoSuchCommentException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected CTComment removeImpl(CTComment ctComment) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)ctComment)) {
                ctComment = (CTComment)session.get(CTCommentImpl.class, ctComment.getPrimaryKeyObj());
            }
            if (ctComment != null) {
                session.delete((Object)ctComment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (ctComment != null) {
            this.clearCache(ctComment);
        }
        return ctComment;
    }

    public CTComment updateImpl(CTComment ctComment) {
        boolean isNew = ctComment.isNew();
        if (!(ctComment instanceof CTCommentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(ctComment.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)ctComment);
                throw new IllegalArgumentException("Implement ModelWrapper in ctComment proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom CTComment implementation " + ctComment.getClass());
        }
        CTCommentModelImpl ctCommentModelImpl = (CTCommentModelImpl)ctComment;
        ServiceContext serviceContext = ServiceContextThreadLocal.getServiceContext();
        Date date = new Date();
        if (isNew && ctComment.getCreateDate() == null) {
            if (serviceContext == null) {
                ctComment.setCreateDate(date);
            } else {
                ctComment.setCreateDate(serviceContext.getCreateDate(date));
            }
        }
        if (!ctCommentModelImpl.hasSetModifiedDate()) {
            if (serviceContext == null) {
                ctComment.setModifiedDate(date);
            } else {
                ctComment.setModifiedDate(serviceContext.getModifiedDate(date));
            }
        }
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)ctComment);
            } else {
                ctComment = (CTComment)session.merge((Object)ctComment);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(CTCommentImpl.class, (BaseModel)ctCommentModelImpl, false, true);
        if (isNew) {
            ctComment.setNew(false);
        }
        ctComment.resetOriginalValues();
        return ctComment;
    }

    public CTComment findByPrimaryKey(Serializable primaryKey) throws NoSuchCommentException {
        CTComment ctComment = (CTComment)this.fetchByPrimaryKey(primaryKey);
        if (ctComment == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchCommentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return ctComment;
    }

    public CTComment findByPrimaryKey(long ctCommentId) throws NoSuchCommentException {
        return this.findByPrimaryKey(Long.valueOf(ctCommentId));
    }

    public CTComment fetchByPrimaryKey(long ctCommentId) {
        return (CTComment)this.fetchByPrimaryKey(Long.valueOf(ctCommentId));
    }

    public List<CTComment> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<CTComment> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<CTComment> findAll(int start, int end, OrderByComparator<CTComment> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<CTComment> findAll(int start, int end, OrderByComparator<CTComment> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_CTCOMMENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_CTCOMMENT;
                sql = sql.concat(" ORDER BY ctComment.ctCommentId DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (CTComment ctComment : this.findAll()) {
            this.remove((BaseModel)ctComment);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_CTCOMMENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "ctCommentId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_CTCOMMENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return CTCommentModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByCtCollectionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCtCollectionId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"ctCollectionId"}, true);
        this._finderPathWithoutPaginationFindByCtCollectionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCtCollectionId", new String[]{Long.class.getName()}, new String[]{"ctCollectionId"}, true);
        this._finderPathCountByCtCollectionId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCtCollectionId", new String[]{Long.class.getName()}, new String[]{"ctCollectionId"}, false);
        this._finderPathWithPaginationFindByCtEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByCtEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"ctEntryId"}, true);
        this._finderPathWithoutPaginationFindByCtEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByCtEntryId", new String[]{Long.class.getName()}, new String[]{"ctEntryId"}, true);
        this._finderPathCountByCtEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByCtEntryId", new String[]{Long.class.getName()}, new String[]{"ctEntryId"}, false);
        CTCommentUtil.setPersistence((CTCommentPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        CTCommentUtil.setPersistence(null);
        this.entityCache.removeCache(CTCommentImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.change.tracking.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.change.tracking.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

