/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.service.impl;

import com.liferay.change.tracking.internal.CTServiceRegistry;
import com.liferay.change.tracking.internal.helper.CTUserNotificationHelper;
import com.liferay.change.tracking.model.CTCollection;
import com.liferay.change.tracking.model.CTEntry;
import com.liferay.change.tracking.model.CTScore;
import com.liferay.change.tracking.model.impl.CTScoreImpl;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.change.tracking.service.base.CTScoreLocalServiceBaseImpl;
import com.liferay.change.tracking.service.persistence.CTCollectionPersistence;
import com.liferay.change.tracking.store.model.CTSContent;
import com.liferay.journal.model.JournalArticle;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.cache.MultiVMPool;
import com.liferay.portal.kernel.cache.PortalCache;
import com.liferay.portal.kernel.change.tracking.CTAware;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.CurrentConnection;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.LockMode;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.increment.BufferedIncrement;
import com.liferay.portal.kernel.increment.NumberIncrement;
import com.liferay.portal.kernel.json.JSONUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.SQLStateAcceptor;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.spring.aop.Property;
import com.liferay.portal.kernel.spring.aop.Retry;
import com.liferay.portal.kernel.transaction.Propagation;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.SetUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@CTAware
@Component(property={"model.class.name=com.liferay.change.tracking.model.CTScore"}, service={AopService.class})
public class CTScoreLocalServiceImpl
extends CTScoreLocalServiceBaseImpl {
    private static final int _COUNT_DIVISOR = 50000000;
    private static final Log _log = LogFactoryUtil.getLog(CTScoreLocalServiceImpl.class);
    @Reference
    private ClassNameLocalService _classNameLocalService;
    @Reference
    private CTCollectionPersistence _ctCollectionPersistence;
    @Reference
    private CTEntryLocalService _ctEntryLocalService;
    @Reference
    private CTServiceRegistry _ctServiceRegistry;
    @Reference
    private CTUserNotificationHelper _ctUserNotificationHelper;
    @Reference
    private CurrentConnection _currentConnection;
    @Reference
    private EntityCache _entityCache;
    @Reference
    private MultiVMPool _multiVMPool;
    private PortalCache<Long, Integer> _portalCache;

    public CTScore addCTScore(long ctCollectionId) {
        CTCollection ctCollection = this._ctCollectionPersistence.fetchByPrimaryKey(ctCollectionId);
        if (ctCollection == null) {
            return null;
        }
        List ctEntries = this._ctEntryLocalService.getCTCollectionCTEntries(ctCollectionId);
        int score = 0;
        for (CTEntry ctEntry : ctEntries) {
            score += this._calculate(ctEntry.getModelClassNameId());
        }
        long ctScoreId = this.counterLocalService.increment(CTScore.class.getName());
        CTScore ctScore = this.ctScorePersistence.create(ctScoreId);
        ctScore.setCompanyId(ctCollection.getCompanyId());
        ctScore.setCtCollectionId(ctCollectionId);
        ctScore.setScore(score);
        return (CTScore)this.ctScorePersistence.update((BaseModel)ctScore);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23,40")})
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public CTScore decrementScore(long ctCollectionId, long modelClassNameId) {
        return this._updateScore(ctCollectionId, modelClassNameId, false);
    }

    public CTScore fetchCTScoreByCTCollectionId(long ctCollectionId) {
        return this.ctScorePersistence.fetchByCtCollectionId(ctCollectionId);
    }

    @BufferedIncrement(incrementClass=NumberIncrement.class)
    @Retry(acceptor=SQLStateAcceptor.class, properties={@Property(name="SQLSTATE", value="23,40")})
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public CTScore incrementScore(long ctCollectionId, long modelClassNameId) {
        return this._updateScore(ctCollectionId, modelClassNameId, true);
    }

    @Activate
    protected void activate(BundleContext bundleContext, Map<String, Object> properties) {
        this._portalCache = this._multiVMPool.getPortalCache(CTScoreLocalServiceImpl.class.getName());
    }

    @Override
    @Deactivate
    protected void deactivate() {
        super.deactivate();
        this._portalCache.removeAll();
    }

    private int _calculate(long modelClassNameId) {
        Integer score = (Integer)this._portalCache.get((Serializable)Long.valueOf(modelClassNameId));
        if (score != null) {
            return score;
        }
        score = 4;
        if (modelClassNameId == this._classNameLocalService.getClassNameId(CTSContent.class)) {
            score = score + 20;
        } else if (modelClassNameId == this._classNameLocalService.getClassNameId(JournalArticle.class)) {
            Integer n = score;
            score = score + 1;
        }
        int countMultiplier = this._countTable(modelClassNameId) / 50000000;
        if (countMultiplier == 0) {
            countMultiplier = 1;
        }
        score = score * countMultiplier;
        DB db = DBManagerUtil.getDB();
        DBType dbType = db.getDBType();
        if (dbType.equals((Object)DBType.ORACLE) || dbType.equals((Object)DBType.SQLSERVER)) {
            score = score * 2;
        }
        this._portalCache.put((Serializable)Long.valueOf(modelClassNameId), (Object)score);
        return score;
    }

    private int _countTable(long modelClassNameId) {
        CTService<?> ctService = this._ctServiceRegistry.getCTService(modelClassNameId);
        if (ctService == null) {
            return 0;
        }
        return (Integer)ctService.updateWithUnsafeFunction(ctPersistence -> {
            Set primaryKeyNames = ctPersistence.getCTColumnNames(CTColumnResolutionType.PK);
            if (primaryKeyNames.size() != 1) {
                throw new IllegalArgumentException(StringBundler.concat((Object[])new Object[]{"{primaryKeyNames=", primaryKeyNames, ", tableName=", ctPersistence.getTableName(), "}"}));
            }
            Iterator iterator = primaryKeyNames.iterator();
            String primaryKeyName = (String)iterator.next();
            Connection connection = this._currentConnection.getConnection(ctPersistence.getDataSource());
            try (PreparedStatement preparedStatement = connection.prepareStatement(StringBundler.concat((String[])new String[]{"select count(", primaryKeyName, ") from ", ctPersistence.getTableName()}));){
                Integer n;
                block20: {
                    ResultSet resultSet;
                    block18: {
                        Integer n2;
                        block19: {
                            resultSet = preparedStatement.executeQuery();
                            try {
                                if (!resultSet.next()) break block18;
                                n2 = resultSet.getInt(1);
                                if (resultSet == null) break block19;
                            }
                            catch (Throwable throwable) {
                                if (resultSet != null) {
                                    try {
                                        resultSet.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            resultSet.close();
                        }
                        return n2;
                    }
                    n = 0;
                    if (resultSet == null) break block20;
                    resultSet.close();
                }
                return n;
            }
            catch (SQLException sqlException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Throwable)sqlException);
                }
                return 0;
            }
        });
    }

    private void _sendUserNotificationEvents(CTScore ctScore, CTScore originalCTScore) {
        String sizeClassification;
        String originalSizeClassification = originalCTScore.getSizeClassification();
        if (Objects.equals(originalSizeClassification, sizeClassification = ctScore.getSizeClassification())) {
            return;
        }
        long ctCollectionId = ctScore.getCtCollectionId();
        try {
            CTCollection ctCollection = this._ctCollectionPersistence.findByPrimaryKey(ctCollectionId);
            Set userIds = SetUtil.fromArray((long[])this._ctUserNotificationHelper.getPublicationRoleUserIds(ctCollection, true, "com_liferay_change_tracking_web_portlet_PublicationsPortlet.admin", "com_liferay_change_tracking_web_portlet_PublicationsPortlet.publisher"));
            this._ctUserNotificationHelper.sendUserNotificationEvents(ctCollection, JSONUtil.put((String)"ctCollectionId", (Object)ctCollectionId).put("notificationType", 1).put("originalSizeClassification", originalSizeClassification).put("sizeClassification", sizeClassification), ArrayUtil.toLongArray((Collection)userIds));
        }
        catch (PortalException portalException) {
            _log.error((Object)"Unable to send user notification events", (Throwable)portalException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CTScore _updateScore(long ctCollectionId, long modelClassNameId, boolean increment) {
        CTCollection ctCollection = this._ctCollectionPersistence.fetchByPrimaryKey(ctCollectionId);
        if (ctCollection == null) {
            return null;
        }
        CTScore originalCTScore = this.ctScorePersistence.fetchByCtCollectionId(ctCollectionId);
        if (ctCollection.isReadOnly()) {
            return originalCTScore;
        }
        if (originalCTScore == null) {
            return this.addCTScore(ctCollectionId);
        }
        int score = this._calculate(modelClassNameId);
        if (!increment) {
            score *= -1;
        }
        Session session = this.ctScorePersistence.openSession();
        CTScore ctScore = null;
        try {
            ctScore = (CTScore)session.get(CTScoreImpl.class, (Serializable)Long.valueOf(originalCTScore.getCtScoreId()), LockMode.UPGRADE);
            if (ctScore == null) {
                CTScore cTScore = ctScore;
                return cTScore;
            }
            score = ctScore.getScore() + score;
            if (score < 0) {
                score = 0;
            }
            ctScore.setScore(score);
            ctScore = (CTScore)session.merge((Object)ctScore);
        }
        finally {
            this.ctScorePersistence.closeSession(session);
        }
        this._entityCache.putResult(CTScoreImpl.class, (BaseModel)ctScore, false, true);
        ctScore.resetOriginalValues();
        this._sendUserNotificationEvents(ctScore, originalCTScore);
        return ctScore;
    }
}

