/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.change.tracking.internal.security.permission.wrapper;

import com.liferay.change.tracking.model.CTCollectionTable;
import com.liferay.change.tracking.service.CTCollectionLocalService;
import com.liferay.change.tracking.service.CTEntryLocalService;
import com.liferay.petra.sql.dsl.DSLQueryFactoryUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.sql.dsl.expression.Expression;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.Layout;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.wrapper.PermissionCheckerWrapper;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.List;
import java.util.function.Supplier;

public class CTOnDemandUserPermissionCheckerWrapper
extends PermissionCheckerWrapper {
    private final ClassNameLocalService _classNameLocalService;
    private final CTCollectionLocalService _ctCollectionLocalService;
    private final CTEntryLocalService _ctEntryLocalService;
    private final PermissionChecker _permissionChecker;

    public CTOnDemandUserPermissionCheckerWrapper(PermissionChecker permissionChecker, ClassNameLocalService classNameLocalService, CTCollectionLocalService ctCollectionLocalService, CTEntryLocalService ctEntryLocalService) {
        super(permissionChecker);
        this._permissionChecker = permissionChecker;
        this._classNameLocalService = classNameLocalService;
        this._ctCollectionLocalService = ctCollectionLocalService;
        this._ctEntryLocalService = ctEntryLocalService;
    }

    public boolean hasPermission(Group group, String name, long primKey, String actionId) {
        return this._hasPermission(name, primKey, actionId, () -> super.hasPermission(group, name, primKey, actionId));
    }

    public boolean hasPermission(Group group, String name, String primKey, String actionId) {
        return this._hasPermission(name, GetterUtil.getLong((String)primKey), actionId, () -> super.hasPermission(group, name, primKey, actionId));
    }

    public boolean hasPermission(long groupId, String name, long primKey, String actionId) {
        return this._hasPermission(name, primKey, actionId, () -> super.hasPermission(groupId, name, primKey, actionId));
    }

    public boolean hasPermission(long groupId, String name, String primKey, String actionId) {
        return this._hasPermission(name, GetterUtil.getLong((String)primKey), actionId, () -> super.hasPermission(groupId, name, primKey, actionId));
    }

    private long _getCTCollectionId() {
        List ctCollectionIds = (List)this._ctCollectionLocalService.dslQuery((DSLQuery)DSLQueryFactoryUtil.selectDistinct((Expression[])new Expression[]{CTCollectionTable.INSTANCE.ctCollectionId}).from((Table)CTCollectionTable.INSTANCE).where(CTCollectionTable.INSTANCE.onDemandUserId.eq((Object)this._permissionChecker.getUserId())));
        if (ctCollectionIds.isEmpty()) {
            return -1L;
        }
        return (Long)ctCollectionIds.get(0);
    }

    private boolean _hasPermission(String name, long primKey, String actionId, Supplier<Boolean> hasPermissionSupplier) {
        if (!StringUtil.equals((String)name, (String)Layout.class.getName()) || !StringUtil.equals((String)actionId, (String)"VIEW")) {
            return hasPermissionSupplier.get();
        }
        long ctCollectionId = this._getCTCollectionId();
        if (ctCollectionId > 0L && this._ctEntryLocalService.hasCTEntry(ctCollectionId, this._classNameLocalService.getClassNameId(Layout.class), primKey)) {
            return true;
        }
        return hasPermissionSupplier.get();
    }
}

